/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.meta.cache.converter;

import com.valor.vod.meta.cache.converter.PlaylistConvert;
import com.valor.vod.meta.cache.model.playlist.Playlist;
import com.valor.vod.meta.cache.model.playlist.PlaylistI18n;
import com.valor.vod.meta.cache.model.playlist.PlaylistNode;
import com.valor.vod.meta.model.database.ddo.playlist.PlaylistDDO;
import com.valor.vod.meta.model.database.ddo.playlist.PlaylistI18nDDO;
import com.valor.vod.meta.model.database.ddo.playlist.PlaylistNodeDDO;
import java.util.ArrayList;
import java.util.List;

public class PlaylistConvertImpl
implements PlaylistConvert {
    private final PlaylistConvert.PlaylistFactory playlistFactory = new PlaylistConvert.PlaylistFactory();

    @Override
    public Playlist convert(PlaylistDDO ddo, List<PlaylistI18nDDO> i18ns) {
        if (ddo == null && i18ns == null) {
            return null;
        }
        Playlist playlist = this.playlistFactory.createPlaylist();
        if (ddo != null) {
            if (ddo.getId() != null) {
                playlist.setId(ddo.getId());
            }
            playlist.setName(ddo.getName());
            if (ddo.getListType() != null) {
                playlist.setListType(ddo.getListType().name());
            }
            playlist.setSourceType(ddo.getSourceType());
            playlist.setExtraType(ddo.getExtraType());
            playlist.setSubType(ddo.getSubType());
            playlist.setSubType2(ddo.getSubType2());
            playlist.setRefId(ddo.getRefId());
            playlist.setOriginalId(ddo.getOriginalId());
            playlist.setCanFilter(ddo.getCanFilter());
            playlist.setTarget(ddo.getTarget());
            playlist.setExtra(ddo.getExtra());
            playlist.setPriceType(ddo.getPriceType());
            playlist.setPrice(ddo.getPrice());
            playlist.setDescription(ddo.getDescription());
            playlist.setSyncStatus(ddo.getSyncStatus());
            playlist.setCanCarousel(ddo.getCanCarousel());
        }
        if (i18ns != null) {
            playlist.setI18ns(this.playlistI18nDDOListToPlaylistI18nList(i18ns));
        }
        return playlist;
    }

    @Override
    public PlaylistI18n convert(PlaylistI18nDDO ddo) {
        if (ddo == null) {
            return null;
        }
        PlaylistI18n playlistI18n = this.playlistFactory.createPlaylistI18n();
        playlistI18n.setLanguage(ddo.getLanguage());
        playlistI18n.setTitle(ddo.getTitle());
        playlistI18n.setPoster(ddo.getPoster());
        playlistI18n.setBackdrop(ddo.getBackdrop());
        playlistI18n.setBackgroundImage(ddo.getBackgroundImage());
        playlistI18n.setIcoNormal(ddo.getIcoNormal());
        playlistI18n.setIcoFocus(ddo.getIcoFocus());
        return playlistI18n;
    }

    @Override
    public PlaylistNode convert(PlaylistNodeDDO ddo) {
        if (ddo == null) {
            return null;
        }
        PlaylistNode playlistNode = this.playlistFactory.createPlaylistNode();
        if (ddo.getId() != null) {
            playlistNode.setId(ddo.getId());
        }
        playlistNode.setNodeType(ddo.getNodeType());
        if (ddo.getVmsId() != null) {
            playlistNode.setVmsId(ddo.getVmsId());
        }
        if (ddo.getSortNo() != null) {
            playlistNode.setSortNo(ddo.getSortNo());
        }
        playlistNode.setExtra(ddo.getExtra());
        return playlistNode;
    }

    protected List<PlaylistI18n> playlistI18nDDOListToPlaylistI18nList(List<PlaylistI18nDDO> list) {
        if (list == null) {
            return null;
        }
        ArrayList<PlaylistI18n> list1 = new ArrayList<PlaylistI18n>(list.size());
        for (PlaylistI18nDDO playlistI18nDDO : list) {
            list1.add(this.convert(playlistI18nDDO));
        }
        return list1;
    }
}

