/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.meta.cache.model.playlist;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.valor.vod.common.tools.type.Expression;
import com.valor.vod.meta.cache.model.playlist.NodeDisplay;
import com.valor.vod.meta.cache.model.playlist.PlaylistI18n;
import com.valor.vod.meta.cache.model.playlist.PlaylistJumpConfigI18n;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class Playlist
implements Serializable {
    private static final long serialVersionUID = -7996538147851539687L;
    private long id;
    private String name;
    private String listType;
    private String sourceType;
    private String extraType;
    private String subType;
    private String subType2;
    private Long refId;
    private String originalId;
    private Integer canFilter;
    private String target;
    private String extra;
    private String priceType;
    private Integer price;
    private String description;
    private String uiVer;
    private String uiKey;
    private String syncStatus;
    private List<PlaylistI18n> i18ns;
    private Map<String, PlaylistI18n> i18nMap = new LinkedHashMap<String, PlaylistI18n>();
    private Map<String, String> targetItemMap;
    @JsonIgnore
    private NodeDisplay nodeDisplay;
    private Map<String, PlaylistJumpConfigI18n> jumpConfigMap = new HashMap<String, PlaylistJumpConfigI18n>();
    private Integer canCarousel;

    public Playlist setI18ns(List<PlaylistI18n> i18ns) {
        this.i18ns = i18ns;
        this.i18nMap = i18ns.stream().filter(Objects::nonNull).collect(Collectors.toMap(PlaylistI18n::getLanguage, e -> e, (v1, v2) -> v2));
        return this;
    }

    public PlaylistI18n getI18n(String language) {
        return this.i18nMap.getOrDefault(language, this.i18nMap.getOrDefault("en", PlaylistI18n.create()));
    }

    public Map<String, String> getTargetItemMap() {
        if (this.targetItemMap == null) {
            this.targetItemMap = new LinkedHashMap<String, String>(Expression.parseAndExpression((String)this.target));
        }
        return this.targetItemMap;
    }

    public PlaylistJumpConfigI18n getJumpConfig(String language) {
        return this.jumpConfigMap.getOrDefault(language, this.jumpConfigMap.get("en"));
    }

    public Playlist setId(long id) {
        this.id = id;
        return this;
    }

    public Playlist setName(String name) {
        this.name = name;
        return this;
    }

    public Playlist setListType(String listType) {
        this.listType = listType;
        return this;
    }

    public Playlist setSourceType(String sourceType) {
        this.sourceType = sourceType;
        return this;
    }

    public Playlist setExtraType(String extraType) {
        this.extraType = extraType;
        return this;
    }

    public Playlist setSubType(String subType) {
        this.subType = subType;
        return this;
    }

    public Playlist setSubType2(String subType2) {
        this.subType2 = subType2;
        return this;
    }

    public Playlist setRefId(Long refId) {
        this.refId = refId;
        return this;
    }

    public Playlist setOriginalId(String originalId) {
        this.originalId = originalId;
        return this;
    }

    public Playlist setCanFilter(Integer canFilter) {
        this.canFilter = canFilter;
        return this;
    }

    public Playlist setTarget(String target) {
        this.target = target;
        return this;
    }

    public Playlist setExtra(String extra) {
        this.extra = extra;
        return this;
    }

    public Playlist setPriceType(String priceType) {
        this.priceType = priceType;
        return this;
    }

    public Playlist setPrice(Integer price) {
        this.price = price;
        return this;
    }

    public Playlist setDescription(String description) {
        this.description = description;
        return this;
    }

    public Playlist setUiVer(String uiVer) {
        this.uiVer = uiVer;
        return this;
    }

    public Playlist setUiKey(String uiKey) {
        this.uiKey = uiKey;
        return this;
    }

    public Playlist setSyncStatus(String syncStatus) {
        this.syncStatus = syncStatus;
        return this;
    }

    public Playlist setNodeDisplay(NodeDisplay nodeDisplay) {
        this.nodeDisplay = nodeDisplay;
        return this;
    }

    public Playlist setJumpConfig(Map<String, PlaylistJumpConfigI18n> jumpConfigMap) {
        if (jumpConfigMap != null) {
            this.jumpConfigMap = jumpConfigMap;
        }
        return this;
    }

    public void setCanCarousel(Integer canCarousel) {
        this.canCarousel = canCarousel;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getListType() {
        return this.listType;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public String getExtraType() {
        return this.extraType;
    }

    public String getSubType() {
        return this.subType;
    }

    public String getSubType2() {
        return this.subType2;
    }

    public Long getRefId() {
        return this.refId;
    }

    public String getOriginalId() {
        return this.originalId;
    }

    public Integer getCanFilter() {
        return this.canFilter;
    }

    public String getTarget() {
        return this.target;
    }

    public String getExtra() {
        return this.extra;
    }

    public String getPriceType() {
        return this.priceType;
    }

    public Integer getPrice() {
        return this.price;
    }

    public String getDescription() {
        return this.description;
    }

    public String getUiVer() {
        return this.uiVer;
    }

    public String getUiKey() {
        return this.uiKey;
    }

    public String getSyncStatus() {
        return this.syncStatus;
    }

    public List<PlaylistI18n> getI18ns() {
        return this.i18ns;
    }

    public NodeDisplay getNodeDisplay() {
        return this.nodeDisplay;
    }

    public Map<String, PlaylistJumpConfigI18n> getJumpConfigMap() {
        return this.jumpConfigMap;
    }

    public Integer getCanCarousel() {
        return this.canCarousel;
    }

    public String toString() {
        return "Playlist(id=" + this.getId() + ", name=" + this.getName() + ", listType=" + this.getListType() + ", sourceType=" + this.getSourceType() + ", extraType=" + this.getExtraType() + ", subType=" + this.getSubType() + ", subType2=" + this.getSubType2() + ", refId=" + this.getRefId() + ", originalId=" + this.getOriginalId() + ", canFilter=" + this.getCanFilter() + ", target=" + this.getTarget() + ", extra=" + this.getExtra() + ", priceType=" + this.getPriceType() + ", price=" + this.getPrice() + ", description=" + this.getDescription() + ", uiVer=" + this.getUiVer() + ", uiKey=" + this.getUiKey() + ", syncStatus=" + this.getSyncStatus() + ", i18ns=" + this.getI18ns() + ", i18nMap=" + this.i18nMap + ", targetItemMap=" + this.getTargetItemMap() + ", nodeDisplay=" + this.getNodeDisplay() + ", jumpConfigMap=" + this.getJumpConfigMap() + ", canCarousel=" + this.getCanCarousel() + ")";
    }

    private Playlist() {
    }

    public static Playlist create() {
        return new Playlist();
    }
}

