/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.meta.cache.service.common;

import com.valor.vod.meta.cache.util.RedisCache;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SyncMediaService {
    @Autowired
    private RedisCache redisCache;

    public <T> void setObjects(String prefix, Map<Long, T> map) {
        HashMap<String, T> pMap = new HashMap<String, T>();
        for (Map.Entry<Long, T> e : map.entrySet()) {
            String key = prefix + e.getKey();
            pMap.put(key, e.getValue());
        }
        this.redisCache.pipSetEx(pMap, 0L);
    }

    public void delObjects(String prefix, Set<Long> vmsIdSet) {
        HashSet<String> keySet = new HashSet<String>();
        for (Long key : vmsIdSet) {
            keySet.add(prefix + key);
        }
        this.redisCache.del(keySet.toArray(new String[0]));
    }

    public <T> T getObject(String prefix, Long vmsId) {
        return (T)this.redisCache.get(prefix + vmsId);
    }
}

