/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.meta.cache.service.query;

import com.google.common.base.Joiner;
import com.valor.vod.meta.cache.constant.LocalizationType;
import com.valor.vod.meta.cache.model.RegionDTO;
import com.valor.vod.meta.model.database.dao.MetaDao;
import com.valor.vod.meta.model.database.ddo.playlist.LocalizationDDO;
import com.valor.vod.meta.model.database.ddo.playlist.PlaylistDDO;
import com.valor.vod.meta.model.database.ddo.playlist.Region;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PlayListDealLocalService {
    private static final Logger log = LoggerFactory.getLogger(PlayListDealLocalService.class);
    @Autowired
    private MetaDao metaDao;

    public void dealLocalTag(PlaylistDDO playlistDdo) {
        String content;
        String target = playlistDdo.getTarget();
        if (StringUtils.isBlank((CharSequence)target) || !target.contains("local:")) {
            return;
        }
        String[] split = target.split("local:");
        Pair<String, String> pair = this.cropLocalName(split[1]);
        LocalizationDDO local = this.metaDao.queryLocalizationByName((String)pair.getLeft());
        if (local == null) {
            return;
        }
        if (LocalizationType.LOCAL_SUBTITLE.desc().equals(local.getType())) {
            content = local.getLocalContent().replaceAll(",", "-");
        } else {
            List dbRegions = this.metaDao.loadRegions();
            List regionDTOS = dbRegions.stream().map(this::convertRegion2Dto).collect(Collectors.toList());
            String[] countries = local.getLocalContent().split(",");
            ArrayList<Long> list = new ArrayList<Long>(countries.length);
            block0: for (String country : countries) {
                for (RegionDTO dto : regionDTOS) {
                    if (!dto.getCode().equals(country)) continue;
                    list.add(dto.getId());
                    continue block0;
                }
            }
            content = Joiner.on((String)"-").join(list);
        }
        String str = split[0] + "local:" + LocalizationType.getValue(local.getType()) + "|" + content + "|" + (String)pair.getRight();
        playlistDdo.setTarget(str);
    }

    private Pair<String, String> cropLocalName(String target) {
        for (int i = 0; i < target.length(); ++i) {
            if (target.charAt(i) != ';' && target.charAt(i) != '&') continue;
            return Pair.of((Object)target.substring(0, i), (Object)target.substring(i));
        }
        return Pair.of((Object)target, (Object)"");
    }

    private RegionDTO convertRegion2Dto(Region region) {
        RegionDTO regionDTO = new RegionDTO();
        regionDTO.setId(region.getId());
        regionDTO.setName(region.getName());
        regionDTO.setCode(region.getCode());
        regionDTO.setOrder(region.getOrder());
        regionDTO.setContinent(region.getContinent());
        return regionDTO;
    }
}

