/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.meta.cache.service.query;

import com.google.common.base.Joiner;
import com.valor.vod.api.common.SetTool;
import com.valor.vod.api.model.cloud.ECloudFileStatus;
import com.valor.vod.es.api.client.EESFilterType;
import com.valor.vod.es.api.model.service.cloud.MediaCloud;
import com.valor.vod.es.api.model.service.cloud.MediaCloudSearchIndex;
import com.valor.vod.es.api.model.service.media.MediaSearchIndex;
import com.valor.vod.es.api.model.service.search.ESSearchParameter;
import com.valor.vod.es.api.model.service.search.ESTermFilterBuilder;
import com.valor.vod.es.api.model.service.search.IESFilterBuilder;
import com.valor.vod.meta.cache.service.common.QueryMediaService;
import com.valor.vod.meta.cache.util.EsCache;
import com.valor.vod.meta.cache.util.RedisCache;
import com.valor.vod.meta.cache.util.RedisPrefix;
import common.base.tools.stat.TimeStatisticsTools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QueryMediaCloudService {
    @Autowired
    RedisCache redisCache;
    @Autowired
    EsCache esCache;
    QueryMediaService<Set<Long>> queryMediaService;

    @PostConstruct
    public void init() {
        this.queryMediaService = new QueryMediaService(this.redisCache);
    }

    public List<MediaCloudSearchIndex> getSearchIndexByCidsAndResIds(Set<Long> cids, Set<String> resIds) {
        ESSearchParameter parameter = ESSearchParameter.builder().index("media_cloud_search_index").type("media_cloud_search_index").size(10000);
        parameter.add((IESFilterBuilder)ESTermFilterBuilder.builder((String)"status").setValue((Object)ECloudFileStatus.DELETE.ordinal()).setFilterType(EESFilterType.MUST_NOT));
        parameter.add((IESFilterBuilder)ESTermFilterBuilder.builder((String)"cid").setValues(cids));
        parameter.add((IESFilterBuilder)ESTermFilterBuilder.builder((String)"resId").setValues(resIds));
        Set indexes = this.esCache.searchWithScroll(parameter);
        return new ArrayList<MediaCloudSearchIndex>(indexes);
    }

    public List<MediaCloudSearchIndex> getSearchIndexByCidsAndVmsIdAndSeason(Set<Long> cids, Long id, Integer season) {
        ESSearchParameter parameter = ESSearchParameter.builder().index("media_cloud_search_index").type("media_cloud_search_index").size(10000);
        parameter.add((IESFilterBuilder)ESTermFilterBuilder.builder((String)"status").setValue((Object)ECloudFileStatus.DELETE.ordinal()).setFilterType(EESFilterType.MUST_NOT));
        parameter.add((IESFilterBuilder)ESTermFilterBuilder.builder((String)"cid").setValues(cids));
        parameter.add((IESFilterBuilder)ESTermFilterBuilder.builder((String)"id").setValue((Object)id));
        parameter.add((IESFilterBuilder)ESTermFilterBuilder.builder((String)"season").setValue((Object)season));
        Set indexes = this.esCache.searchWithScroll(parameter);
        return new ArrayList<MediaCloudSearchIndex>(indexes);
    }

    public List<MediaCloudSearchIndex> getSearchIndexByVmsId(Long vmsId) {
        ESSearchParameter parameter = ESSearchParameter.builder().index("media_cloud_search_index").type("media_cloud_search_index").size(10000);
        parameter.add((IESFilterBuilder)ESTermFilterBuilder.builder((String)"status").setValue((Object)ECloudFileStatus.DELETE.ordinal()).setFilterType(EESFilterType.MUST_NOT));
        parameter.add((IESFilterBuilder)ESTermFilterBuilder.builder((String)"id").setValue((Object)vmsId));
        Set indexes = this.esCache.searchWithScroll(parameter);
        return new ArrayList<MediaCloudSearchIndex>(indexes);
    }

    public List<MediaCloudSearchIndex> getSearchIndexByVmsId(Long vmsId, int season, int episode) {
        ESSearchParameter parameter = ESSearchParameter.builder().index("media_cloud_search_index").type("media_cloud_search_index").size(10000);
        parameter.add((IESFilterBuilder)ESTermFilterBuilder.builder((String)"status").setValue((Object)ECloudFileStatus.DELETE.ordinal()).setFilterType(EESFilterType.MUST_NOT));
        parameter.add((IESFilterBuilder)ESTermFilterBuilder.builder((String)"id").setValue((Object)vmsId));
        parameter.add((IESFilterBuilder)ESTermFilterBuilder.builder((String)"season").setValue((Object)season));
        parameter.add((IESFilterBuilder)ESTermFilterBuilder.builder((String)"episode").setValue((Object)episode));
        Set indexes = this.esCache.search(parameter);
        return new ArrayList<MediaCloudSearchIndex>(indexes);
    }

    public Map<MediaCloudSearchIndex, MediaCloud> getMediaCloudByIndex(List<MediaCloudSearchIndex> searchIndexes) {
        long beginTime = System.currentTimeMillis();
        HashSet<String> docIdSet = new HashSet<String>();
        HashMap<String, MediaCloudSearchIndex> keyMap = new HashMap<String, MediaCloudSearchIndex>();
        for (MediaCloudSearchIndex searchIndex : searchIndexes) {
            String key = RedisPrefix.MediaCloud + searchIndex.getDocumentId();
            docIdSet.add(key);
            keyMap.put(key, searchIndex);
        }
        Map map = this.redisCache.mGet(docIdSet);
        HashMap<MediaCloudSearchIndex, MediaCloud> cloudMap = new HashMap<MediaCloudSearchIndex, MediaCloud>();
        for (Map.Entry e : map.entrySet()) {
            if (!keyMap.containsKey(e.getKey())) continue;
            cloudMap.put((MediaCloudSearchIndex)keyMap.get(e.getKey()), (MediaCloud)e.getValue());
        }
        TimeStatisticsTools.addTime((String)"REDIS-getMediaCloudByIndex", (int)1, (long)(System.currentTimeMillis() - beginTime));
        return cloudMap;
    }

    public Map<Long, Set<Long>> getVmsIdByCids(Set<Long> cidSet) {
        long beginTime = System.currentTimeMillis();
        Map<Long, Set<Long>> result = this.queryMediaService.getObjectByVmsIds(RedisPrefix.MediaCloudCidId, cidSet);
        TimeStatisticsTools.addTime((String)"REDIS-getVmsIdByCids", (int)1, (long)(System.currentTimeMillis() - beginTime));
        return result;
    }

    public Set<Long> getGenreByCid(Long cid) {
        Map<Long, Set<Long>> result = this.getGenreByCids(SetTool.asHashSet((Object[])new Long[]{cid}));
        return result.getOrDefault(cid, new HashSet());
    }

    public Map<Long, Set<Long>> getGenreByCids(Set<Long> cidSet) {
        long beginTime = System.currentTimeMillis();
        Map<Long, Set<Long>> result = this.queryMediaService.getObjectByVmsIds(RedisPrefix.CloudGenre, cidSet);
        TimeStatisticsTools.addTime((String)"REDIS-getGenreByCids", (int)1, (long)(System.currentTimeMillis() - beginTime));
        return result;
    }

    public Set<MediaSearchIndex> getMediaSearchIndexes(Long vmsId, List<Long> userCidList, List<String> audios) {
        ESSearchParameter parameter = ESSearchParameter.builder().index("media_search_index").type("media_search_index").size(10000);
        parameter.add((IESFilterBuilder)ESTermFilterBuilder.builder((String)"seriesId").setValue((Object)vmsId));
        ArrayList<String> cloudLangs = new ArrayList<String>();
        for (String language : audios) {
            for (Long userCid : userCidList) {
                cloudLangs.add(Joiner.on((String)"#").skipNulls().join((Object)userCid, (Object)language, new Object[0]));
            }
        }
        parameter.add((IESFilterBuilder)ESTermFilterBuilder.builder((String)"cloudsAudioLanguage").setValues(cloudLangs));
        return this.esCache.searchWithScroll(parameter);
    }

    public List<MediaCloudSearchIndex> getSearchIndexByVmsIds(Long vmsId) {
        ESSearchParameter parameter = ESSearchParameter.builder().index("media_cloud_search_index").type("media_cloud_search_index").size(10000);
        parameter.add((IESFilterBuilder)ESTermFilterBuilder.builder((String)"id").setValue((Object)vmsId));
        Set indexes = this.esCache.searchWithScroll(parameter);
        return new ArrayList<MediaCloudSearchIndex>(indexes);
    }
}

