/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.meta.cache.service.query;

import com.valor.vod.es.api.model.service.media.MediaImage;
import com.valor.vod.meta.cache.service.common.QueryMediaService;
import com.valor.vod.meta.cache.util.RedisCache;
import com.valor.vod.meta.cache.util.RedisPrefix;
import common.base.tools.stat.TimeStatisticsTools;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QueryMediaImageService {
    @Autowired
    RedisCache redisCache;
    QueryMediaService<List<MediaImage>> queryMediaService;

    @PostConstruct
    public void init() {
        this.queryMediaService = new QueryMediaService(this.redisCache);
    }

    public Map<Long, List<MediaImage>> getMediaImageByVmsIds(Set<Long> idSet) {
        long beginTime = System.currentTimeMillis();
        Map<Long, List<MediaImage>> result = this.queryMediaService.getObjectByVmsIds(RedisPrefix.MediaImage, idSet);
        TimeStatisticsTools.addTime((String)"REDIS-getMediaImageByVmsIds", (int)1, (long)(System.currentTimeMillis() - beginTime));
        return result;
    }

    public List<MediaImage> getMediaImageByVmsId(Long id) {
        HashSet<Long> idSet = new HashSet<Long>();
        idSet.add(id);
        Map<Long, List<MediaImage>> map = this.getMediaImageByVmsIds(idSet);
        return map.getOrDefault(id, new ArrayList());
    }
}

