/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.meta.cache.service.query;

import com.valor.vod.api.common.SetTool;
import com.valor.vod.es.api.model.service.media.MediaParentsGuide;
import com.valor.vod.meta.cache.service.common.QueryMediaService;
import com.valor.vod.meta.cache.util.RedisCache;
import com.valor.vod.meta.cache.util.RedisPrefix;
import common.base.tools.stat.TimeStatisticsTools;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QueryMediaParentsGuideService {
    @Autowired
    RedisCache redisCache;
    QueryMediaService<List<MediaParentsGuide>> queryMediaService;

    @PostConstruct
    public void init() {
        this.queryMediaService = new QueryMediaService(this.redisCache);
    }

    public Map<Long, List<MediaParentsGuide>> getMediaParentsGuideByVmsIds(Set<Long> idSet) {
        long beginTime = System.currentTimeMillis();
        Map<Long, List<MediaParentsGuide>> result = this.queryMediaService.getObjectByVmsIds(RedisPrefix.MediaParentsGuide, idSet);
        TimeStatisticsTools.addTime((String)"REDIS-getMediaParentsGuideByVmsIds", (int)1, (long)(System.currentTimeMillis() - beginTime));
        return result;
    }

    public List<MediaParentsGuide> getMediaParentsGuideByVmsId(Long id) {
        Map<Long, List<MediaParentsGuide>> map = this.getMediaParentsGuideByVmsIds(SetTool.asHashSet((Object[])new Long[]{id}));
        return map.getOrDefault(id, new ArrayList());
    }
}

