/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.meta.cache.service.query;

import com.valor.vod.api.common.SetTool;
import com.valor.vod.meta.cache.util.RedisCache;
import com.valor.vod.meta.cache.util.RedisPrefix;
import common.base.tools.stat.TimeStatisticsTools;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QueryMediaSimilarService {
    @Autowired
    RedisCache redisCache;

    private Set<String> getKeySet(Set<Long> idSet) {
        HashSet<String> keySet = new HashSet<String>();
        for (Long id : idSet) {
            String key = RedisPrefix.MediaSimilar + id;
            keySet.add(key);
        }
        return keySet;
    }

    public Map<Long, LinkedHashSet<Long>> getSimilarByVmsIds(Set<Long> idSet) {
        long beginTime = System.currentTimeMillis();
        Set<String> keySet = this.getKeySet(idSet);
        Map detailMap = this.redisCache.mGet(keySet);
        HashMap<Long, LinkedHashSet<Long>> resultMap = new HashMap<Long, LinkedHashSet<Long>>();
        for (Map.Entry e : detailMap.entrySet()) {
            LinkedHashSet set = new LinkedHashSet((Collection)e.getValue());
            Long id = Long.parseLong(e.getKey().substring(RedisPrefix.MediaSimilar.length()));
            resultMap.put(id, set);
        }
        TimeStatisticsTools.addTime((String)"REDIS-getSimilarByVmsIds", (int)1, (long)(System.currentTimeMillis() - beginTime));
        return resultMap;
    }

    public LinkedHashSet<Long> getSimilarByVmsId(Long id) {
        Map<Long, LinkedHashSet<Long>> map = this.getSimilarByVmsIds(SetTool.asHashSet((Object[])new Long[]{id}));
        return map.getOrDefault(id, new LinkedHashSet());
    }

    public Set<Long> getNewSimilarByVmsId(Long vmsId) {
        return (Set)this.redisCache.get(RedisPrefix.MediaSimilarNew + vmsId);
    }
}

