/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.meta.cache.service.query;

import com.valor.vod.api.common.SetTool;
import com.valor.vod.es.api.model.service.media.MediaUserReview;
import com.valor.vod.meta.cache.service.common.QueryMediaService;
import com.valor.vod.meta.cache.util.RedisCache;
import com.valor.vod.meta.cache.util.RedisPrefix;
import common.base.tools.stat.TimeStatisticsTools;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QueryMediaUserReviewService {
    @Autowired
    RedisCache redisCache;
    QueryMediaService<List<MediaUserReview>> queryMediaService;

    @PostConstruct
    public void init() {
        this.queryMediaService = new QueryMediaService(this.redisCache);
    }

    public Map<Long, List<MediaUserReview>> getMediaUserReviewByVmsIds(Set<Long> idSet) {
        long beginTime = System.currentTimeMillis();
        Map<Long, List<MediaUserReview>> result = this.queryMediaService.getObjectByVmsIds(RedisPrefix.MediaUserReview, idSet);
        TimeStatisticsTools.addTime((String)"REDIS-getMediaUserReviewByVmsIds", (int)1, (long)(System.currentTimeMillis() - beginTime));
        return result;
    }

    public List<MediaUserReview> getMediaUserReviewByVmsId(Long id) {
        Map<Long, List<MediaUserReview>> map = this.getMediaUserReviewByVmsIds(SetTool.asHashSet((Object[])new Long[]{id}));
        return map.getOrDefault(id, new ArrayList());
    }
}

