/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.meta.cache.service.query;

import com.valor.vod.common.tools.type.CollectionUtils;
import com.valor.vod.meta.cache.converter.PlaylistConvert;
import com.valor.vod.meta.cache.model.playlist.Playlist;
import com.valor.vod.meta.cache.model.playlist.PlaylistNode;
import com.valor.vod.meta.cache.service.query.PlayListDealLocalService;
import com.valor.vod.meta.model.database.constants.playlist.EPlaylistListType;
import com.valor.vod.meta.model.database.constants.playlist.EPlaylistRefListSubType;
import com.valor.vod.meta.model.database.dao.MetaDao;
import com.valor.vod.meta.model.database.ddo.openapi.MetaOpenConfigDDO;
import com.valor.vod.meta.model.database.ddo.playlist.PlaylistDDO;
import com.valor.vod.meta.model.database.ddo.playlist.PlaylistI18nDDO;
import com.valor.vod.meta.model.database.ddo.playlist.PlaylistNodeDDO;
import com.valor.vod.meta.model.database.tools.playlist.PlaylistIdTools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QueryOpenApiService {
    private static final Logger log = LoggerFactory.getLogger(QueryOpenApiService.class);
    @Autowired
    private MetaDao metaDao;
    @Autowired
    private PlayListDealLocalService playListDealLocalService;

    public List<MetaOpenConfigDDO> queryOpenApiCfg(List<Long> openIds) {
        List metaOpenConfigDDOS = CollectionUtils.isNullOrEmpty(openIds) ? this.metaDao.getListData(false, MetaOpenConfigDDO.class, null) : this.metaDao.getMetaOpenConfigByOpenIds(openIds);
        return metaOpenConfigDDOS;
    }

    public PlaylistDDO queryPlaylist(Long playlistId) {
        PlaylistDDO playlistDDO = this.metaDao.getPlaylistById(playlistId);
        this.playListDealLocalService.dealLocalTag(playlistDDO);
        return playlistDDO;
    }

    public List<PlaylistNodeDDO> batchQueryPlaylistNode(List<Long> playlistIds) {
        if (CollectionUtils.isNullOrEmpty(playlistIds)) {
            return new ArrayList<PlaylistNodeDDO>();
        }
        List playlistNodeDDOS = this.metaDao.getPlaylistNodeByIds(playlistIds);
        List<PlaylistNodeDDO> sortPlaylistNodeDDOS = playlistNodeDDOS.stream().sorted(Comparator.comparing(PlaylistNodeDDO::getSortNo)).collect(Collectors.toList());
        return sortPlaylistNodeDDOS;
    }

    public List<PlaylistI18nDDO> batchQueryPlaylistI18n(List<Long> playlistIds) {
        if (CollectionUtils.isNullOrEmpty(playlistIds)) {
            return new ArrayList<PlaylistI18nDDO>();
        }
        List playlistI18nDDOS = this.metaDao.getPlaylistI18nByIds(playlistIds);
        return playlistI18nDDOS;
    }

    public Playlist bulidPlayList(Long playlistId) {
        PlaylistDDO playlistDDO = this.queryPlaylist(playlistId);
        if (playlistDDO == null) {
            return null;
        }
        playlistDDO = this.mergePlaylist(playlistDDO);
        List<PlaylistI18nDDO> playlistI18nList = this.mergeI18ns(playlistDDO);
        Playlist playlist = PlaylistConvert.INSTANCE.convert(playlistDDO, playlistI18nList);
        return playlist;
    }

    public List<PlaylistNode> buildPlaylistNode(Playlist playlist) {
        List<PlaylistNodeDDO> playlistNodeList = this.batchQueryPlaylistNode(Arrays.asList(playlist.getId()));
        playlistNodeList = this.mergeChildNodes(playlist, playlistNodeList);
        List<PlaylistNode> playlistNodes = playlistNodeList.stream().map(PlaylistConvert.INSTANCE::convertIf).filter(Objects::nonNull).collect(Collectors.toList());
        return playlistNodes;
    }

    private void setRefId(PlaylistDDO target) {
        if (target.getListType() != EPlaylistListType.REF_LIST) {
            return;
        }
        if (EPlaylistRefListSubType.STAR.name().equals(target.getSubType())) {
            target.setRefId(PlaylistIdTools.getId((String)"10000000", (EPlaylistRefListSubType)EPlaylistRefListSubType.STAR));
        } else if (EPlaylistRefListSubType.ON_THE_AIR.name().equals(target.getSubType())) {
            target.setRefId(PlaylistIdTools.getId((String)"10000000", (EPlaylistRefListSubType)EPlaylistRefListSubType.ON_THE_AIR));
        }
    }

    public PlaylistDDO mergePlaylist(PlaylistDDO target) {
        PlaylistDDO src;
        if (target.getRefId() == null) {
            if (target.getListType() != EPlaylistListType.REF_LIST) {
                return target;
            }
            if (EPlaylistRefListSubType.STAR.name().equals(target.getSubType())) {
                target.setRefId(PlaylistIdTools.getId((String)"10000000", (EPlaylistRefListSubType)EPlaylistRefListSubType.STAR));
            } else if (EPlaylistRefListSubType.ON_THE_AIR.name().equals(target.getSubType())) {
                target.setRefId(PlaylistIdTools.getId((String)"10000000", (EPlaylistRefListSubType)EPlaylistRefListSubType.ON_THE_AIR_LINKED));
            }
            if (target.getRefId() == null) {
                return target;
            }
        }
        if ((src = this.queryPlaylist(target.getRefId())) == null) {
            return target;
        }
        target.setListType(src.getListType());
        target.setSourceType(src.getSourceType());
        if (ObjectUtils.isEmpty((Object)target.getName())) {
            target.setName(src.getName());
        }
        if (ObjectUtils.isEmpty((Object)target.getExtraType())) {
            target.setExtraType(src.getExtraType());
        }
        if (ObjectUtils.isEmpty((Object)target.getSubType())) {
            target.setSubType(src.getSubType());
        }
        if (ObjectUtils.isEmpty((Object)target.getRefId())) {
            target.setRefId(src.getRefId());
        }
        if (ObjectUtils.isEmpty((Object)target.getOriginalId())) {
            target.setOriginalId(src.getOriginalId());
        }
        if (ObjectUtils.isEmpty((Object)target.getCanFilter())) {
            target.setCanFilter(src.getCanFilter());
        }
        if (ObjectUtils.isEmpty((Object)target.getTarget())) {
            target.setTarget(src.getTarget());
        }
        if (ObjectUtils.isEmpty((Object)target.getExtra())) {
            target.setExtra(src.getExtra());
        }
        if (ObjectUtils.isEmpty((Object)target.getPriceType())) {
            target.setPriceType(src.getPriceType());
        }
        if (ObjectUtils.isEmpty((Object)target.getPrice())) {
            target.setPrice(src.getPrice());
        }
        if (ObjectUtils.isEmpty((Object)target.getDescription())) {
            target.setDescription(src.getDescription());
        }
        if (ObjectUtils.isEmpty((Object)target.getStatus())) {
            target.setStatus(src.getStatus());
        }
        if (ObjectUtils.isEmpty((Object)target.getSyncStatus())) {
            target.setSyncStatus(src.getSyncStatus());
        }
        return target;
    }

    public List<PlaylistI18nDDO> mergeI18ns(PlaylistDDO target) {
        List<PlaylistI18nDDO> targetList = this.batchQueryPlaylistI18n(Arrays.asList(target.getId()));
        if (target.getRefId() == null) {
            return targetList;
        }
        List<PlaylistI18nDDO> srcList = this.batchQueryPlaylistI18n(Arrays.asList(target.getRefId()));
        if (ObjectUtils.isEmpty(srcList)) {
            return targetList;
        }
        Long targetPlaylistId = target.getId();
        BinaryOperator mergeOp = (s, t) -> {
            if (ObjectUtils.isEmpty((Object)s)) {
                return t;
            }
            if (ObjectUtils.isEmpty((Object)t)) {
                return s;
            }
            if (ObjectUtils.isEmpty((Object)t.getTitle())) {
                t.setTitle(s.getTitle());
            }
            if (ObjectUtils.isEmpty((Object)t.getPoster())) {
                t.setPoster(s.getPoster());
            }
            if (ObjectUtils.isEmpty((Object)t.getBackdrop())) {
                t.setBackdrop(s.getBackdrop());
            }
            if (ObjectUtils.isEmpty((Object)t.getBackgroundImage())) {
                t.setBackgroundImage(s.getBackgroundImage());
            }
            if (ObjectUtils.isEmpty((Object)t.getIcoNormal())) {
                t.setIcoNormal(s.getIcoNormal());
            }
            if (ObjectUtils.isEmpty((Object)t.getIcoFocus())) {
                t.setIcoFocus(s.getIcoFocus());
            }
            return t;
        };
        Map srcMap = srcList.stream().collect(Collectors.toMap(PlaylistI18nDDO::getLanguage, Function.identity()));
        Map targetMap = targetList.stream().collect(Collectors.toMap(PlaylistI18nDDO::getLanguage, Function.identity()));
        Map<String, PlaylistI18nDDO> dest = Stream.concat(srcMap.entrySet().stream(), targetMap.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, mergeOp));
        return dest.values().stream().peek(e -> e.setPlaylistId(targetPlaylistId)).collect(Collectors.toList());
    }

    private List<PlaylistNodeDDO> mergeChildNodes(Playlist target, List<PlaylistNodeDDO> targetList) {
        if (target.getRefId() == null) {
            return targetList;
        }
        List<PlaylistNodeDDO> srcList = this.batchQueryPlaylistNode(Arrays.asList(target.getRefId()));
        srcList.forEach(e -> e.setParentPlaylistId(Long.valueOf(target.getId())));
        ArrayList<PlaylistNodeDDO> res = new ArrayList<PlaylistNodeDDO>();
        if (!CollectionUtils.isNullOrEmpty(srcList)) {
            res.addAll(srcList);
        }
        if (!CollectionUtils.isNullOrEmpty(targetList)) {
            res.addAll(targetList);
        }
        return res;
    }
}

