/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.meta.cache.service.query;

import com.valor.vod.es.api.model.service.playlist.PlaylistNodeIndex;
import com.valor.vod.meta.cache.util.EsCache;
import common.config.tools.config.ConfigTools3;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.util.Pair;
import org.springframework.stereotype.Service;

@Service
public class QueryPlaylistNodeService {
    @Autowired
    private EsCache esCache;
    private final String useRootNodeIdKey = "playlist.node.use.rootNodeId";

    public List<PlaylistNodeIndex> getPlaylistNodeIndexByParentPlaylistId(Long rootNodeId, Long parentPlaylistId, boolean queryOnTheAirLinked, boolean subHasTimingConfig) {
        BoolQueryBuilder bqb = this.buildPlaylistQuery(rootNodeId, parentPlaylistId, queryOnTheAirLinked, subHasTimingConfig);
        SearchSourceBuilder ssb = new SearchSourceBuilder();
        ssb.size(10000);
        ssb.query((QueryBuilder)bqb);
        ssb.sort("sortNo", SortOrder.ASC);
        Pair pair = this.esCache.searchWithScroll(ssb, this.getPlaylistNodeIndexName(), "playlist_node");
        return new ArrayList<PlaylistNodeIndex>((Collection)pair.getSecond());
    }

    public List<PlaylistNodeIndex> getPlaylistNodeIndexByParentPlaylistId(Long rootNodeId, Long parentPlaylistId, boolean queryOnTheAirLinked, int from, int size, boolean subHasTimingConfig) {
        BoolQueryBuilder bqb = this.buildPlaylistQuery(rootNodeId, parentPlaylistId, queryOnTheAirLinked, subHasTimingConfig);
        SearchSourceBuilder ssb = new SearchSourceBuilder();
        ssb.from(from).size(size);
        ssb.query((QueryBuilder)bqb);
        ssb.sort("sortNo", SortOrder.ASC);
        Set indexes = this.esCache.search(ssb, this.getPlaylistNodeIndexName(), "playlist_node");
        return new ArrayList<PlaylistNodeIndex>(indexes);
    }

    public int countPlaylistNodes(Long rootNodeId, Long parentPlaylistId, boolean queryOnTheAirLinked, boolean subHasTimingConfig) {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.size(0);
        BoolQueryBuilder bqb = this.buildPlaylistQuery(rootNodeId, parentPlaylistId, queryOnTheAirLinked, subHasTimingConfig);
        searchSourceBuilder.query((QueryBuilder)bqb);
        SearchResponse response = this.esCache.searchResponse(searchSourceBuilder, this.getPlaylistNodeIndexName(), "playlist_node");
        return (int)response.getHits().totalHits;
    }

    private BoolQueryBuilder buildPlaylistQuery(long rootNodeId, long parentPlaylistId, boolean queryOnTheAirLinked, boolean subHasTimingConfig) {
        BoolQueryBuilder bqb = QueryBuilders.boolQuery();
        BoolQueryBuilder filterQueryBuilder = QueryBuilders.boolQuery();
        filterQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"parentPlaylistId", (long)parentPlaylistId));
        if (ConfigTools3.getBoolean((String)"playlist.node.use.rootNodeId", (boolean)true)) {
            filterQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"rootNodeId", (long)rootNodeId));
        }
        if (queryOnTheAirLinked) {
            filterQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"type", (String)"lineked"));
        } else {
            filterQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termQuery((String)"type", (String)"lineked"));
        }
        if (subHasTimingConfig) {
            this.buildTimingQuery(filterQueryBuilder);
        }
        bqb.filter((QueryBuilder)filterQueryBuilder);
        if (subHasTimingConfig) {
            this.buildTimingQuery(bqb);
        }
        return bqb;
    }

    private void buildTimingQuery(BoolQueryBuilder queryBuilder) {
        long currentMillis = Instant.now().toEpochMilli();
        BoolQueryBuilder startTimingQueryBuilder = new BoolQueryBuilder();
        BoolQueryBuilder startTimeStampNotExistQuery = QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"startTimeStamp"));
        BoolQueryBuilder startTimeStampGteQuery = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.rangeQuery((String)"startTimeStamp").lte((Object)currentMillis));
        startTimingQueryBuilder.should((QueryBuilder)startTimeStampNotExistQuery).should((QueryBuilder)startTimeStampGteQuery);
        BoolQueryBuilder endTimingQueryBuilder = new BoolQueryBuilder();
        BoolQueryBuilder endTimeStampNotExistQuery = QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"endTimeStamp"));
        BoolQueryBuilder endTimeStampGteQuery = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.rangeQuery((String)"endTimeStamp").gte((Object)currentMillis));
        endTimingQueryBuilder.should((QueryBuilder)endTimeStampNotExistQuery).should((QueryBuilder)endTimeStampGteQuery);
        queryBuilder.must((QueryBuilder)startTimingQueryBuilder).must((QueryBuilder)endTimingQueryBuilder);
    }

    private String getPlaylistNodeIndexName() {
        return ConfigTools3.getString((String)"index.playlistNode", (String)"playlist_node");
    }
}

