/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.meta.cache.service.query;

import com.valor.vod.meta.cache.util.RedisPrefix;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class QueryYmlService {
    @Autowired
    private RedisTemplate redisTemplate;

    public int getDateVersion() {
        Object version = this.redisTemplate.opsForValue().get((Object)RedisPrefix.YmlDateVersion);
        if (version != null) {
            return Integer.parseInt(version.toString());
        }
        return -1;
    }

    public List<Long> queryFromTop(Set<String> randomSet) {
        int dateInt = this.getDateVersion();
        List videos = this.redisTemplate.opsForHash().multiGet((Object)(RedisPrefix.YmlTopContent + dateInt), randomSet);
        return videos.stream().filter(Objects::nonNull).map(Integer::longValue).collect(Collectors.toList());
    }
}

