/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.meta.cache.util;

import com.valor.vod.common.tools.type.CollectionUtils;
import com.valor.vod.meta.cache.util.RedisCacheable;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.stereotype.Service;

@Service
public class RedisCache
implements RedisCacheable {
    private static final Logger logger = LoggerFactory.getLogger(RedisCache.class);
    @Autowired
    private RedisTemplate cacheRedisTemplate;

    private void expLog(String fun, Exception ex) {
    }

    @Override
    public void del(String ... keys) {
        try {
            if (keys != null && keys.length > 0) {
                if (keys.length == 1) {
                    this.cacheRedisTemplate.delete((Object)keys[0]);
                } else {
                    this.cacheRedisTemplate.delete(Arrays.asList(keys));
                }
            }
        }
        catch (Exception ex) {
            logger.error("del(),exception:{}", (Throwable)ex);
            this.expLog("del()", ex);
        }
    }

    @Override
    public Boolean exists(String key) {
        try {
            return this.cacheRedisTemplate.hasKey((Object)key);
        }
        catch (Exception ex) {
            logger.error("exists(),exception:{}", (Throwable)ex);
            this.expLog("exists()", ex);
            return null;
        }
    }

    @Override
    public void expire(String key, int seconds) {
        try {
            if (seconds > 0) {
                this.cacheRedisTemplate.expire((Object)key, (long)seconds, TimeUnit.SECONDS);
            }
        }
        catch (Exception ex) {
            logger.error("expire(),exception:{}", (Throwable)ex);
            this.expLog("expire()", ex);
        }
    }

    @Override
    public void pExpire(String key, int milliseconds) {
        try {
            if (milliseconds > 0) {
                this.cacheRedisTemplate.expire((Object)key, (long)milliseconds, TimeUnit.MILLISECONDS);
            }
        }
        catch (Exception ex) {
            logger.error("pExpire(),exception:{}", (Throwable)ex);
            this.expLog("pExpire()", ex);
        }
    }

    @Override
    public Set<String> keys(String pattern) {
        try {
            Set keysSet = this.cacheRedisTemplate.keys((Object)pattern);
            return keysSet;
        }
        catch (Exception ex) {
            logger.error("keys(),exception:{}", (Throwable)ex);
            this.expLog("keys()", ex);
            return null;
        }
    }

    @Override
    public void rename(String key, String newKey) {
        try {
            this.cacheRedisTemplate.rename((Object)key, (Object)newKey);
        }
        catch (Exception ex) {
            logger.error("rename(),exception:{}", (Throwable)ex);
            this.expLog("rename()", ex);
        }
    }

    @Override
    public Long decr(String key) {
        try {
            return this.cacheRedisTemplate.opsForValue().increment((Object)key, -1L);
        }
        catch (Exception ex) {
            logger.error("decr(),exception:{}", (Throwable)ex);
            this.expLog("decr()", ex);
            return null;
        }
    }

    @Override
    public Long decrBy(String key, long decrement) {
        try {
            return this.cacheRedisTemplate.opsForValue().increment((Object)key, -decrement);
        }
        catch (Exception ex) {
            logger.error("decrBy(),exception:{}", (Throwable)ex);
            this.expLog("decrBy()", ex);
            return null;
        }
    }

    @Override
    public Long incr(String key) {
        try {
            return this.cacheRedisTemplate.opsForValue().increment((Object)key, 1L);
        }
        catch (Exception ex) {
            logger.error("incr(),exception:{}", (Throwable)ex);
            this.expLog("incr()", ex);
            return null;
        }
    }

    @Override
    public Long incrBy(String key, long decrement) {
        try {
            return this.cacheRedisTemplate.opsForValue().increment((Object)key, decrement);
        }
        catch (Exception ex) {
            logger.error("incrBy(),exception:{}", (Throwable)ex);
            this.expLog("incrBy()", ex);
            return null;
        }
    }

    @Override
    public <V> V get(String key) {
        try {
            Object obj = this.cacheRedisTemplate.opsForValue().get((Object)key);
            return (V)obj;
        }
        catch (Exception ex) {
            logger.error("get(),exception:{}", (Throwable)ex);
            this.expLog("get()", ex);
            return null;
        }
    }

    @Override
    public <V> V getSet(String key, V value) {
        try {
            return (V)this.cacheRedisTemplate.opsForValue().getAndSet((Object)key, value);
        }
        catch (Exception ex) {
            logger.error("getSet(),exception:{}", (Throwable)ex);
            this.expLog("getSet()", ex);
            return null;
        }
    }

    @Override
    public <V> List<V> mGet(String ... keys) {
        try {
            List objs = this.cacheRedisTemplate.opsForValue().multiGet(Arrays.asList(keys));
            int fireCount = 0;
            if (objs != null) {
                for (int i = 0; i < objs.size(); ++i) {
                    if (objs.get(i) == null) continue;
                    ++fireCount;
                }
            }
            return objs;
        }
        catch (Exception ex) {
            logger.error("mGet(),exception:{}", (Throwable)ex);
            this.expLog("mGet()", ex);
            return null;
        }
    }

    public <V> Map<String, V> mGet(Set<String> keySet) {
        try {
            ArrayList<String> keys = new ArrayList<String>(keySet);
            List objs = this.cacheRedisTemplate.opsForValue().multiGet(keys);
            int fireCount = 0;
            if (objs != null) {
                for (int i = 0; i < objs.size(); ++i) {
                    if (objs.get(i) == null) continue;
                    ++fireCount;
                }
            }
            HashMap resultMap = new HashMap();
            for (int i = 0; i < keys.size(); ++i) {
                Object v = objs.get(i);
                if (v == null) continue;
                resultMap.put(keys.get(i), v);
            }
            return resultMap;
        }
        catch (Exception ex) {
            logger.error("mGet(),exception:{}", (Throwable)ex);
            this.expLog("mGet()", ex);
            throw ex;
        }
    }

    @Override
    public <V> void mSet(Map<String, V> keyValueMap) {
        try {
            this.cacheRedisTemplate.opsForValue().multiSet(keyValueMap);
        }
        catch (Exception ex) {
            logger.error("mSet(),exception:{}", (Throwable)ex);
            this.expLog("mSet()", ex);
        }
    }

    @Override
    public <V> void mSetNx(Map<String, V> keyValueMap) {
        try {
            this.cacheRedisTemplate.opsForValue().multiSetIfAbsent(keyValueMap);
        }
        catch (Exception ex) {
            logger.error("mSetNx(),exception:{}", (Throwable)ex);
            this.expLog("mSetNx()", ex);
        }
    }

    @Override
    public <V> void set(String key, V value) {
        try {
            this.cacheRedisTemplate.opsForValue().set((Object)key, value);
        }
        catch (Exception ex) {
            logger.error("set(),exception:{}", (Throwable)ex);
            this.expLog("set()", ex);
        }
    }

    @Override
    public <V> void setEx(String key, V value, long seconds) {
        try {
            if (seconds > 0L) {
                this.cacheRedisTemplate.opsForValue().set((Object)key, value, seconds, TimeUnit.SECONDS);
            } else {
                this.cacheRedisTemplate.opsForValue().set((Object)key, value);
            }
        }
        catch (Exception ex) {
            logger.error("setEx(),exception:{}", (Throwable)ex);
            this.expLog("setEx()", ex);
        }
    }

    @Override
    public <V> void pipSetEx(final Map<String, V> map, final long seconds) {
        try {
            List list = this.cacheRedisTemplate.executePipelined((RedisCallback)new RedisCallback<Object>(){

                public Object doInRedis(RedisConnection redisConnection) throws DataAccessException {
                    for (Map.Entry e : map.entrySet()) {
                        String key = (String)e.getKey();
                        Object value = e.getValue();
                        RedisSerializer redisSerializer = RedisCache.this.cacheRedisTemplate.getValueSerializer();
                        if (seconds > 0L) {
                            redisConnection.setEx(key.getBytes(), seconds, redisSerializer.serialize(value));
                            continue;
                        }
                        redisConnection.set(key.getBytes(), redisSerializer.serialize(value));
                    }
                    return null;
                }
            }, this.cacheRedisTemplate.getValueSerializer());
        }
        catch (Exception ex) {
            logger.error("pipHashSetEx(),exception:{}", (Throwable)ex);
            this.expLog("pipHashSetEx()", ex);
        }
    }

    @Override
    public <V> void pipSetExs(final List<Map<String, V>> maps, final long seconds) {
        try {
            List list = this.cacheRedisTemplate.executePipelined((RedisCallback)new RedisCallback<Object>(){

                public Object doInRedis(RedisConnection redisConnection) throws DataAccessException {
                    for (int i = 0; i < maps.size(); ++i) {
                        Map map = (Map)maps.get(i);
                        for (Map.Entry e : map.entrySet()) {
                            String key = (String)e.getKey();
                            Object value = e.getValue();
                            RedisSerializer redisSerializer = RedisCache.this.cacheRedisTemplate.getValueSerializer();
                            if (seconds > 0L) {
                                redisConnection.setEx(key.getBytes(), seconds, redisSerializer.serialize(value));
                                continue;
                            }
                            redisConnection.set(key.getBytes(), redisSerializer.serialize(value));
                        }
                    }
                    return null;
                }
            }, this.cacheRedisTemplate.getValueSerializer());
        }
        catch (Exception ex) {
            logger.error("pipSetExs(),exception:{}", (Throwable)ex);
            this.expLog("pipSetExs()", ex);
        }
    }

    @Override
    public <V> void pSetEx(String key, V value, long milliseconds) {
        try {
            if (milliseconds > 0L) {
                this.cacheRedisTemplate.opsForValue().set((Object)key, value, milliseconds, TimeUnit.MILLISECONDS);
            } else {
                this.cacheRedisTemplate.opsForValue().set((Object)key, value);
            }
        }
        catch (Exception ex) {
            logger.error("pSetEx(),exception:{}", (Throwable)ex);
            this.expLog("pSetEx()", ex);
        }
    }

    @Override
    public <V> void setNx(String key, V value) {
        try {
            this.cacheRedisTemplate.opsForValue().setIfAbsent((Object)key, value);
        }
        catch (Exception ex) {
            logger.error("setNx(),exception:{}", (Throwable)ex);
            this.expLog("setNx()", ex);
        }
    }

    @Override
    public Boolean setNxEx(String key, String value, long seconds) {
        try {
            return this.cacheRedisTemplate.opsForValue().setIfAbsent((Object)key, (Object)value, Duration.ofSeconds(seconds));
        }
        catch (Exception ex) {
            try {
                this.cacheRedisTemplate.delete((Object)key);
            }
            catch (Exception exception) {
                // empty catch block
            }
            logger.error("setNxEx(),exception:{}", (Throwable)ex);
            this.expLog("setNxEx()", ex);
            return null;
        }
    }

    private byte[] serialize(String key) {
        return key.getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public Boolean pSetNxEx(String key, String value, long milliseconds) {
        try {
            return this.cacheRedisTemplate.opsForValue().setIfAbsent((Object)key, (Object)value, Duration.ofMillis(milliseconds));
        }
        catch (Exception ex) {
            try {
                this.cacheRedisTemplate.delete((Object)key);
            }
            catch (Exception exception) {
                // empty catch block
            }
            logger.error("pSetNxEx(),exception:{}", (Throwable)ex);
            this.expLog("pSetNxEx()", ex);
            return null;
        }
    }

    @Override
    public void hDel(String key, String ... fields) {
        try {
            this.cacheRedisTemplate.opsForHash().delete((Object)key, (Object[])fields);
        }
        catch (Exception ex) {
            logger.error("hDel(),exception:{}", (Throwable)ex);
            this.expLog("hDel()", ex);
        }
    }

    @Override
    public Boolean hExists(String key, String field) {
        try {
            return this.cacheRedisTemplate.opsForHash().hasKey((Object)key, (Object)field);
        }
        catch (Exception ex) {
            logger.error("hExists(),exception:{}", (Throwable)ex);
            this.expLog("hExists()", ex);
            return null;
        }
    }

    @Override
    public <V> V hGet(String key, String field) {
        try {
            Object obj = this.cacheRedisTemplate.opsForHash().get((Object)key, (Object)field);
            return (V)obj;
        }
        catch (Exception ex) {
            logger.error("hGet(),exception:{}", (Throwable)ex);
            this.expLog("hGet()", ex);
            return null;
        }
    }

    @Override
    public <V> Map<String, V> hGetAll(String key) {
        try {
            Map map = this.cacheRedisTemplate.opsForHash().entries((Object)key);
            return map;
        }
        catch (Exception ex) {
            logger.error("hGetAll(),exception:{}", (Throwable)ex);
            this.expLog("hGetAll()", ex);
            return null;
        }
    }

    @Override
    public Set<String> hKeys(String key) {
        try {
            return this.cacheRedisTemplate.opsForHash().keys((Object)key);
        }
        catch (Exception ex) {
            logger.error("hKeys(),exception:{}", (Throwable)ex);
            this.expLog("hKeys()", ex);
            return null;
        }
    }

    @Override
    public <V> List<V> hMGet(String key, String ... fields) {
        try {
            List list = this.cacheRedisTemplate.opsForHash().multiGet((Object)key, Arrays.asList(fields));
            return list;
        }
        catch (Exception ex) {
            logger.error("hMGet(),exception:{}", (Throwable)ex);
            this.expLog("hMGet()", ex);
            return null;
        }
    }

    @Override
    public <V> void hMSet(String key, Map<String, V> fieldMap) {
        try {
            this.cacheRedisTemplate.opsForHash().putAll((Object)key, fieldMap);
        }
        catch (Exception ex) {
            logger.error("hMSet(),exception:{}", (Throwable)ex);
            this.expLog("hMSet()", ex);
        }
    }

    @Override
    public <V> void hSet(String key, String field, V value) {
        try {
            this.cacheRedisTemplate.opsForHash().put((Object)key, (Object)field, value);
        }
        catch (Exception ex) {
            logger.error("hSet(),exception:{}", (Throwable)ex);
            this.expLog("hSet()", ex);
        }
    }

    @Override
    public <V> void hSetNx(String key, String field, V value) {
        try {
            this.cacheRedisTemplate.opsForHash().putIfAbsent((Object)key, (Object)field, value);
        }
        catch (Exception ex) {
            logger.error("hSetNx(),exception:{}", (Throwable)ex);
            this.expLog("hSetNx()", ex);
        }
    }

    @Override
    public <V> List<Map<String, V>> pipHashGetAll(final String ... keys) {
        try {
            List objects = this.cacheRedisTemplate.executePipelined(new RedisCallback<Map<String, V>>(){

                public Map<String, V> doInRedis(RedisConnection redisConnection) throws DataAccessException {
                    for (String key : keys) {
                        redisConnection.get(key.getBytes());
                    }
                    return null;
                }
            });
            int fireCount = 0;
            if (objects != null && objects.size() == keys.length) {
                for (int i = 0; i < objects.size(); ++i) {
                    Map obj = (Map)objects.get(i);
                    if (obj == null || obj.size() == 0) continue;
                    ++fireCount;
                }
            }
            return objects;
        }
        catch (Exception ex) {
            logger.error("pipHashGetAll(),exception:{}", (Throwable)ex);
            this.expLog("pipHashGetAll()", ex);
            return null;
        }
    }

    @Override
    public <V> void pipHashSetEx(final Map<String, Map<String, V>> hMap, final long seconds) {
        try {
            List list = this.cacheRedisTemplate.executePipelined((RedisCallback)new RedisCallback<Object>(){

                public Object doInRedis(RedisConnection redisConnection) throws DataAccessException {
                    for (Map.Entry e : hMap.entrySet()) {
                        String key = (String)e.getKey();
                        Map value = (Map)e.getValue();
                        byte[] valBytes = RedisCache.this.cacheRedisTemplate.getValueSerializer().serialize((Object)value);
                        if (seconds > 0L) {
                            redisConnection.setEx(key.getBytes(), seconds, valBytes);
                            continue;
                        }
                        redisConnection.set(key.getBytes(), valBytes);
                    }
                    return null;
                }
            });
        }
        catch (Exception ex) {
            logger.error("pipHashSetEx(),exception:{}", (Throwable)ex);
            this.expLog("pipHashSetEx()", ex);
        }
    }

    @Override
    public <V> void sAdd(String key, V ... members) {
        try {
            this.cacheRedisTemplate.opsForSet().add((Object)key, (Object[])members);
        }
        catch (Exception ex) {
            logger.error("sAdd(),exception:{}", (Throwable)ex);
            this.expLog("sAdd()", ex);
        }
    }

    @Override
    public Long sCard(String key) {
        try {
            return this.cacheRedisTemplate.opsForSet().size((Object)key);
        }
        catch (Exception ex) {
            logger.error("sCard(),exception:{}", (Throwable)ex);
            this.expLog("sCard()", ex);
            return null;
        }
    }

    @Override
    public Boolean sIsMember(String key, Object member) {
        try {
            return this.cacheRedisTemplate.opsForSet().isMember((Object)key, member);
        }
        catch (Exception ex) {
            logger.error("sIsMember(),exception:{}", (Throwable)ex);
            this.expLog("sIsMember()", ex);
            return null;
        }
    }

    @Override
    public <V> Set<V> sMembers(String key) {
        try {
            return this.cacheRedisTemplate.opsForSet().members((Object)key);
        }
        catch (Exception ex) {
            logger.error("sMembers(),exception:{}", (Throwable)ex);
            this.expLog("sMembers()", ex);
            return null;
        }
    }

    @Override
    public <V> List<Set<V>> pipSetMembers(final String ... keys) {
        try {
            List objects = this.cacheRedisTemplate.executePipelined(new RedisCallback<Set<V>>(){

                public Set<V> doInRedis(RedisConnection redisConnection) throws DataAccessException {
                    for (String key : keys) {
                        redisConnection.get(key.getBytes());
                    }
                    return null;
                }
            });
            int fireCount = 0;
            if (objects != null && objects.size() == keys.length) {
                for (int i = 0; i < objects.size(); ++i) {
                    Set obj = (Set)objects.get(i);
                    if (obj == null || obj.size() == 0) continue;
                    ++fireCount;
                }
            }
            return objects;
        }
        catch (Exception ex) {
            logger.error("pipSMembers(),exception:{}", (Throwable)ex);
            this.expLog("pipSMembers()", ex);
            return null;
        }
    }

    @Override
    public <V> void pipSetAddEx(final Map<String, Set<V>> sMap, final long seconds) {
        try {
            List list = this.cacheRedisTemplate.executePipelined((RedisCallback)new RedisCallback<Object>(){

                public Object doInRedis(RedisConnection redisConnection) throws DataAccessException {
                    for (Map.Entry e : sMap.entrySet()) {
                        String key = (String)e.getKey();
                        Set value = (Set)e.getValue();
                        byte[] valBytes = RedisCache.this.cacheRedisTemplate.getValueSerializer().serialize((Object)value);
                        if (seconds > 0L) {
                            redisConnection.setEx(key.getBytes(), seconds, valBytes);
                            continue;
                        }
                        redisConnection.set(key.getBytes(), valBytes);
                    }
                    return null;
                }
            });
        }
        catch (Exception ex) {
            logger.error("pipSAdd(),exception:{}", (Throwable)ex);
            this.expLog("pipSAdd()", ex);
        }
    }

    @Override
    public <V> void pipSetAdd(Map<String, V[]> smap) {
        try {
            List list = this.cacheRedisTemplate.executePipelined(redisConnection -> {
                for (Map.Entry e : smap.entrySet()) {
                    String key = (String)e.getKey();
                    Object[] values = (Object[])e.getValue();
                    byte[][] vs = new byte[values.length][];
                    for (int i = 0; i < values.length; ++i) {
                        Object v = values[i];
                        byte[] valBytes = this.cacheRedisTemplate.getValueSerializer().serialize(v);
                        vs[i] = valBytes;
                    }
                    redisConnection.setCommands().sAdd(key.getBytes(), (byte[][])vs);
                }
                return null;
            });
        }
        catch (Exception ex) {
            logger.error("pipSetAdd(),exception:{}", (Throwable)ex);
            this.expLog("pipSetAdd()", ex);
        }
    }

    @Override
    public <V> Map<String, Set<V>> mMembers(Set<String> keys) {
        HashMap<String, Set<Set>> result = new HashMap<String, Set<Set>>();
        try {
            for (String key : keys) {
                Set s = this.cacheRedisTemplate.opsForSet().members((Object)key);
                if (CollectionUtils.isNullOrEmpty((Collection)s)) continue;
                result.put(key, s);
            }
        }
        catch (Exception ex) {
            logger.error("mMembers(),exception:{}", (Throwable)ex);
            this.expLog("mMembers()", ex);
        }
        return result;
    }

    @Override
    public void sRem(String key, Object ... members) {
        try {
            this.cacheRedisTemplate.opsForSet().remove((Object)key, members);
        }
        catch (Exception ex) {
            logger.error("sRem(),exception:{}", (Throwable)ex);
            this.expLog("sRem()", ex);
        }
    }
}

