package com.valor.vod.meta.model.database.constants;


import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum EListLanguage {
    //该列表对所有用户展示
    ALL,
    //该列表对当前系统语言为非葡语与西语的用户展示
    EN,
    //该列表对当前系统语言为葡语的用户展示（葡语包含葡萄牙葡语，巴西葡语）
    PT,
    //该列表对当前系统语言为西语的用户展示
    ES;

    private static final Map<String, EListLanguage> valueMap = Stream.of(values())
        .collect(Collectors.toMap(EListLanguage::name, e -> e));

    public static EListLanguage of(String value) {
        if (value == null) {
            return null;
        }

        return valueMap.get(value.toUpperCase(Locale.ENGLISH));
    }
}
