package com.valor.vod.meta.model.database.constants;

import com.google.common.base.Strings;

/**
 * Created by Frank.Huang on 2016/6/22.
 */
public enum EMediaStatus {
    UNKNOWN,         //未知
    RUMORED,         //传闻
    PLANNED,         //计划
    IN_PRODUCTION,   //拍摄中
    POST_PRODUCTION, //后期制作
    RELEASED,        //已发行
    CANCELED;        //取消

/*
-----------------------------------
| Rumored              |      795 |
| Planned              |      291 |
| In Production        |      401 |
| Post Production      |      759 |
| Released             |   201077 |
| Canceled             |       21 |
-----------------------------------
*/

    public static EMediaStatus valueOfStr(String v) {
        if (Strings.isNullOrEmpty(v)) {
            return UNKNOWN;
        }

        switch (v.trim()) {
            case "Rumored":
                return RUMORED;
            case "Planned":
                return PLANNED;
            case "In Production":
                return IN_PRODUCTION;
            case "Post Production":
                return POST_PRODUCTION;
            case "Released":
                return RELEASED;
            case "Canceled":
                return CANCELED;
            default:
                return UNKNOWN;
        }
    }
}
