package com.valor.vod.meta.model.database.constants.playlist;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author Tom Tang
 * @date 2021/8/31
 * @since 3.0.0
 */
public enum EConfigListSubType {
    /**
     *
     */
    ON_THE_AIR,
    SECOND_AUDIO,
    GENRES,
    GENRES_WITH_SELECTED,
    TAGS,
    TAGS_WITH_SELECTED;

    private static final Map<String, EConfigListSubType> VALUE_MAP = Stream.of(values())
        .collect(Collectors.toMap(EConfigListSubType::name, Function.identity()));

    public static EConfigListSubType of(String value) {
        if (value == null) {
            return null;
        }

        return VALUE_MAP.get(value);
    }
}
