package com.valor.vod.meta.model.database.constants.playlist;

import org.springframework.util.Assert;

/**
 *
 *
 * @author Damon.Gao
 * @date 2021/7/28 13:51
 */
public enum EPlaylistRefListSubType {
    AWARD_BASE_EVENT(101),
    AWARD_EVENT(102),
    AWARD_CATEGORY(103),
    DIRECTOR(104),
    STAR(105),
    TOPIC(106),
    SERIES(107),
    IN_THEATER(108),
    COMMON_LIST(109),
    ON_THE_AIR(110),
    SECOND_AUDIO(111),
    ON_THE_AIR_LINKED(112);

    /**
     * 系数
     */
    private final int factor;

    EPlaylistRefListSubType(int factor) {
        Assert.isTrue( factor > 100 && factor < 999, "Invalid Factor Range. factor: " + factor + "!");
        this.factor = factor;
    }

    public int getFactor() {
        return factor;
    }

}
