package com.valor.vod.meta.model.database.dao.query.filter;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.valor.vod.api.model.filter.FilterHelper;

import java.util.Set;

/**
 * Project     : volor
 * Description :
 * Author      : Frank
 * Create Time : 2016/1/5 12:55
 */
public class FilterField {
    private String key;
    private String operator;
    private Set<String> values = Sets.newHashSet();

    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getOperator() {
        return operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public Set<String> getValues() {
        return values;
    }

    public void setValues(Set<String> values) {
        this.values = values;
    }

    public void addValue(String value) {
        if (isCharacter()) {
            values.add("'" + value + "'");
        } else {
            values.add(value);
        }
    }

    public boolean isRange() {
        if (Strings.isNullOrEmpty(operator)) {
            return false;
        }

        if (FilterHelper.FILTER_IN.equalsIgnoreCase(operator.trim())
            || FilterHelper.FILTER_NOT_IN.equalsIgnoreCase(operator.trim())) {
            return true;
        } else {
            return false;
        }
    }

    public boolean isCharacter() {
        return false;
    }

    @Override
    public String toString() {

        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[key:");
        stringBuilder.append(key);
        stringBuilder.append(" value:");
        stringBuilder.append(Joiner.on(" ").join(values));
        stringBuilder.append(" operator:");
        stringBuilder.append(operator);
        stringBuilder.append("]");

        return stringBuilder.toString();
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(key, operator, values);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        FilterField that = (FilterField) o;
        return Objects.equal(key, that.key) &&
            Objects.equal(operator, that.operator) &&
            Objects.equal(values, that.values);
    }
}
