package com.valor.vod.meta.model.database.dao.query.filter.alias;

import com.google.common.collect.ImmutableMap;

import java.util.Map;

/**
 * Created by Frank.Huang on 2016/5/13.
 */
public class SqlOrderAlias {

    private static Map<String, String> sortMapping = new ImmutableMap.Builder<String, String>()
        .put("popularity", SqlQueryAlias.TABLE_META + ".popularity")
        .put("rating", SqlQueryAlias.TABLE_META + ".WR")
        .put("release_date", SqlQueryAlias.TABLE_META + ".release_date_int")
        .put("linkedTime", SqlQueryAlias.TABLE_META + ".linked_time")
        .put("lastAirDate", SqlQueryAlias.TABLE_META + ".has_reserve1")
        .build();

    private static Map<String, String> linkedSortMapping = new ImmutableMap.Builder<String, String>()
        .put("popularity", SqlQueryAlias.TABLE_META_LINKED + ".popularity")
        .put("rating", SqlQueryAlias.TABLE_META_LINKED + ".WR")
        .put("release_date", SqlQueryAlias.TABLE_META_LINKED + ".release_date_int")
        .put("linkedTime", SqlQueryAlias.TABLE_META_LINKED + ".linked_time")
        .put("lastAirDate", SqlQueryAlias.TABLE_META_LINKED + ".has_reserve1")
        .build();


    public static String getSortField(int linked, String key) {
        if (linked == 1) {
            return linkedSortMapping.getOrDefault(key, "");
        } else {
            return sortMapping.getOrDefault(key, "");
        }
    }
}
