package com.valor.vod.meta.model.database.dao.query.filter.filter;

import com.valor.vod.meta.model.database.dao.query.filter.FilterField;

/**
 * Created by Frank.Huang on 2016/8/17.
 */
public class AssociateFieldFilter implements IFieldFilter {
    protected String tableName = "";
    protected String fieldName = "";
    protected boolean isCharacter = false;
    protected IFilterValueConverter converter = null;

    protected String associateTableName = "";
    protected String associateFieldName = "";
    protected String associateFilterFieldName = "";

    public AssociateFieldFilter(String tableName, String fieldName, boolean isCharacter, IFilterValueConverter converter, String relTableName, String relFieldName, String relFilterFieldName) {
        this.tableName = tableName;
        this.fieldName = fieldName;
        this.isCharacter = isCharacter;
        this.converter = converter;
        this.associateTableName = relTableName;
        this.associateFieldName = relFieldName;
        this.associateFilterFieldName = relFilterFieldName;
    }

    @Override
    public String getFilter(FilterField field) {
        StringBuilder sb = new StringBuilder();

        IFieldFilter filter = new BaseFieldFilter(associateTableName, associateFilterFieldName, false, null);
        sb.append(tableName + "." + fieldName)
            .append(" in(")
            .append("select distinct ")
            .append(associateFieldName)
            .append(" from ")
            .append(associateTableName)
            .append(" where ")
            .append(filter.getFilter(field))
            .append(")");

        return sb.toString();
    }
}
