package com.valor.vod.meta.model.database.dao.query.filter.filter;

import com.google.common.collect.ImmutableMap;
import com.valor.vod.api.model.filter.FilterHelper;
import com.valor.vod.meta.model.database.dao.query.filter.FilterField;
import com.valor.vod.meta.model.database.dao.query.filter.alias.SqlQueryAlias;
import com.valor.vod.meta.model.database.dao.query.filter.filter.converter.LinkedTimeConverter;
import com.valor.vod.meta.model.database.dao.query.filter.filter.converter.RatingConverter;
import com.valor.vod.meta.model.database.dao.query.filter.filter.converter.ReleaseDateConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Created by Frank.Huang on 2016/8/17.
 */
public class FilterTools {
    private static final Logger logger = LoggerFactory.getLogger(FilterTools.class);

    public static ImmutableMap<String, IFieldFilter> fieldFilterMap = ImmutableMap.<String, IFieldFilter>builder()
        .put(FilterHelper.FILTER_RATING, new BaseFieldFilter(SqlQueryAlias.TABLE_META, "rating", false, new RatingConverter()))
        .put(FilterHelper.FILTER_RELEASE_YEAR, new BaseFieldFilter(SqlQueryAlias.TABLE_META, "publication_year", false, null))
        .put(FilterHelper.FILTER_RELEASE_DATE, new BaseFieldFilter(SqlQueryAlias.TABLE_META, "release_date_int", false, new ReleaseDateConverter()))
        .put(FilterHelper.FILTER_LAST_AIR_DATE, new BaseFieldFilter(SqlQueryAlias.TABLE_META, "has_reserve1", false, new ReleaseDateConverter()))
        .put(FilterHelper.FILTER_ANIMATION, new BaseFieldFilter(SqlQueryAlias.TABLE_META, "is_animation", false, null))
        .put(FilterHelper.FILTER_FAMILY, new BaseFieldFilter(SqlQueryAlias.TABLE_META, "is_family", false, null))
        .put(FilterHelper.FILTER_HOLLYWOOD, new BaseFieldFilter(SqlQueryAlias.TABLE_META, "is_hollywood", false, null))
        .put(FilterHelper.FILTER_LATIN, new BaseFieldFilter(SqlQueryAlias.TABLE_META, "is_latin", false, null))
        .put(FilterHelper.FILTER_ASIA, new BaseFieldFilter(SqlQueryAlias.TABLE_META, "is_asia", false, null))
        .put(FilterHelper.FILTER_NOT_LANG_EN, new BaseFieldFilter(SqlQueryAlias.TABLE_META, "is_reserve1", false, null))

        .put(FilterHelper.FILTER_LINKED_TIME, new BaseFieldFilter(SqlQueryAlias.TABLE_META, "linked_time", false, new LinkedTimeConverter()))
        .put(FilterHelper.FILTER_LINKED, new BaseFieldFilter(SqlQueryAlias.TABLE_META, "linked", false, null))

        .put(FilterHelper.FILTER_GENRE, new GenreFilter())
        .put(FilterHelper.FILTER_COUNTRY, new CountryFilter())
        .build();


    public static String buildQueryFilter(FilterField field) {
        if (field == null) {
            return "";
        }

        IFieldFilter filter = fieldFilterMap.get(field.getKey());
        if (filter == null) {
            logger.error("Can NOT filter for key[{}]", field.getKey());
            return "";
        }

        return filter.getFilter(field);
    }
}
