package com.valor.vod.meta.model.database.dao.tools;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.valor.vod.meta.model.database.ddo.media.base.AbstractReleaseInfo;
import com.valor.vod.meta.model.database.ddo.media.emum.EReleaseType;
import com.valor.vod.common.tools.type.CollectionUtils;
import com.valor.vod.common.tools.type.DateTimeTools;

import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/**
 * Created by Frank.Huang on 2016/7/20.
 */
public class ReleaseDateTools {
    private Map<String, String> regionDateMap = Maps.newHashMap();
    private String firstReleaseDate = "";
    private int firstReleaseDateInt = Integer.MAX_VALUE;

    public ReleaseDateTools(List relList) {
        if (!CollectionUtils.isNullOrEmpty(relList)) {
            relList.forEach(e -> {
                if (e instanceof AbstractReleaseInfo) {
                    AbstractReleaseInfo releaseInfo = (AbstractReleaseInfo) e;
                    int d = DateTimeTools.date2IntVal(releaseInfo.getReleaseDate());
                    if (d < firstReleaseDateInt) {
                        firstReleaseDateInt = d;
                        firstReleaseDate = releaseInfo.getReleaseDate();
                    }

                    String sd1 = regionDateMap.get(releaseInfo.getCountry().toLowerCase());
                    if (Strings.isNullOrEmpty(sd1)) {
                        regionDateMap.put(releaseInfo.getCountry().toLowerCase(), releaseInfo.getReleaseDate());
                    } else {
                        int d1 = DateTimeTools.date2IntVal(sd1);
                        if (d != 0 && d < d1) {
                            regionDateMap.put(releaseInfo.getCountry().toLowerCase(), releaseInfo.getReleaseDate());
                        }
                    }
                }
            });
        }
    }

    public static EReleaseType getReleaseDateType(String title) {
        if (Strings.isNullOrEmpty(title)) {
            return EReleaseType.THEATRICAL;
        }

        for (EReleaseStrType strType : EReleaseStrType.values()) {
            if (title.indexOf(strType.getValue()) >= 0) {
                switch (strType) {
                    case DEFAULT:
                        return EReleaseType.THEATRICAL;
                    case LIMITED:
                        return EReleaseType.THEATRICAL_LIMITED;
                    case FESTIVAL:
                        return EReleaseType.FILM_FESTIVAL;
                    case PREMIERE:
                        return EReleaseType.PREMIERE;
                    case INTERNET:
                        return EReleaseType.INTERNET;
                    case BLUE_RAY:
                        return EReleaseType.BLUE_RAY;
                    case RE_RELEASE:
                        return EReleaseType.RE_RELEASE;
                    case TV:
                        return EReleaseType.TV;
                }
            }
        }

        return EReleaseType.OTHER;
    }

    public static String formatENReleaseDate(String releaseDateStr) {
        if (Strings.isNullOrEmpty(releaseDateStr)) {
            return "";
        }

        releaseDateStr = releaseDateStr.replace(".", "");
        Date date = null;
        if (releaseDateStr.length() >= 10) {
            //format:dd MMMM yyyy
            date = DateTimeTools.getDateFromLocaleStr(releaseDateStr, "dd MMMM yyyy", Locale.ENGLISH);
        } else if (releaseDateStr.length() > 4) {
            //format:MMMM yyyy
            date = DateTimeTools.getDateFromLocaleStr(releaseDateStr, "MMMM yyyy", Locale.ENGLISH);
        } else {
            //format:yyyy
            date = DateTimeTools.getDateFromLocaleStr(releaseDateStr, "yyyy", Locale.ENGLISH);
        }

        if (date == null) {
            return "";
        }

        return DateTimeTools.getDateStr(date, "yyyy-MM-dd", "");
    }

    public String getFirstReleaseDate() {
        return firstReleaseDate;
    }

    public String getRegionReleaseDate(String region) {
        return regionDateMap.getOrDefault(region.toLowerCase(), "");
    }


    public enum EReleaseStrType {

        RE_RELEASE("re-release"),

        DEFAULT("default"),
        PREMIERE("premiere"),
        LIMITED("limited"),
        FESTIVAL("Festival"),

        INTERNET("internet"),
        BLUE_RAY("Blu-ray"),
        TV("TV");


        private String value;

        EReleaseStrType(String value) {
            this.value = value;
        }

        public String getValue() {
            return value;
        }
    }
}
