/*
 *      Copyright (c) 2004-2015 YAMJ Members
 *      https://github.com/organizations/YAMJ/teams
 *
 *      This file is part of the Yet Another Media Jukebox (YAMJ).
 *
 *      YAMJ is free software: you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation, either version 3 of the License, or
 *      any later version.
 *
 *      YAMJ is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with YAMJ.  If not, see <http://www.gnu.org/licenses/>.
 *
 *      Web: https://github.com/YAMJ/yamj-v3
 *
 */
package com.valor.vod.meta.model.database.ddo.configuation;

import com.valor.vod.common.database.model.AbstractLMI;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

@Entity
@Table(name = "vms_config")
public class MFCConfiguration extends AbstractLMI {

    private static final long serialVersionUID = -3985190780763596771L;

    @Id
    @Column(name = "config_key", nullable = false, length = 255)
    private String key;

    @Column(name = "config_value", length = 2048)
    private String value;

    // GETTER and SETTER
    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    // EQUALITY CHECKS
    @Override
    public int hashCode() {
        return new HashCodeBuilder()
            .append(getKey())
            .toHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof MFCConfiguration) {
            final MFCConfiguration other = (MFCConfiguration) obj;
            return new EqualsBuilder()
                .append(getKey(), other.getKey())
                .isEquals();
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MFCConfiguration [Key='");
        sb.append(getKey());
        sb.append("', value='");
        sb.append(getValue());
        sb.append("']");
        return sb.toString();
    }
}
