package com.valor.vod.meta.model.database.ddo.configuation.i18n;

import com.google.common.base.Strings;
import com.valor.vod.common.database.model.AbstractLMI;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;

/**
 * Created by Frank.Huang on 2016/8/2.
 */
@MappedSuperclass
public class AbstractI18n extends AbstractLMI {
    @Id
    @Column(name = "language", length = 8)
    private String language;

    @Id
    @Column(name = "original", length = 190)
    private String original;

    @Column(name = "target", length = 1024)
    private String target;

    public String getLanguage() {
        return language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getOriginal() {
        return original;
    }

    public void setOriginal(String original) {
        this.original = original;
    }

    public String getTarget() {
        return target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public boolean isInvalid() {
        return Strings.isNullOrEmpty(language)
            || Strings.isNullOrEmpty(original)
            || Strings.isNullOrEmpty(target);
    }
}
