package com.valor.vod.meta.model.database.ddo.linked;

import com.valor.vod.api.model.constant.EVideoType;
import com.valor.vod.common.database.model.AbstractLMI;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

import javax.persistence.*;

/**
 * Created by Frank.Huang on 2016/11/3.
 */
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
@Entity
@Table(name = "linked_cloud_multi_episode", indexes = {
    @Index(name = "linked_cloud_multi_episode_cid", columnList = "cid"),
    @Index(name = "linked_cloud_multi_episode_vse", columnList = "video_id,season,episode")
})
public class LinkedCloudMultiEpisodeDdo extends AbstractLMI {
    @Id
    @Column(name = "cid")
    public Long cid = -1L;

    @Id
    @Column(name = "res_id", length = 128)
    private String resId;

    @Id
    @Column(name = "season")
    private int season;

    @Id
    @Column(name = "episode")
    private int episode;

    @Id
    @Column(name = "meta_id", length = 64)
    private String metaId;

    @Column(name = "video_id")
    private long videoId = -1;

    @Enumerated(EnumType.ORDINAL)
    @Column(name = "video_type")
    private EVideoType videoType = EVideoType.UNKNOWN;

    public Long getCid() {
        return cid;
    }

    public void setCid(Long cid) {
        this.cid = cid;
    }

    public String getResId() {
        return resId;
    }

    public void setResId(String resId) {
        this.resId = resId;
    }

    public int getSeason() {
        return season;
    }

    public void setSeason(int season) {
        this.season = season;
    }

    public int getEpisode() {
        return episode;
    }

    public void setEpisode(int episode) {
        this.episode = episode;
    }

    public String getMetaId() {
        return metaId;
    }

    public void setMetaId(String metaId) {
        this.metaId = metaId;
    }

    public long getVideoId() {
        return videoId;
    }

    public void setVideoId(long videoId) {
        this.videoId = videoId;
    }

    public EVideoType getVideoType() {
        return videoType;
    }

    public void setVideoType(EVideoType videoType) {
        this.videoType = videoType;
    }
}
