package com.valor.vod.meta.model.database.ddo.media;

import com.google.common.base.Objects;
import com.valor.vod.common.database.model.AbstractLMI;
import com.valor.vod.meta.model.database.ddo.media.base.AbstractTag;
import com.valor.vod.common.tools.type.DdoKeyTools;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

import javax.persistence.*;

/**
 * Created by Chris.Zeng on 2020/7/20.
 */
@Entity
@Table(name = "vms_media_tag", indexes = {@Index(name = "mediaIdIndex", columnList = "media_id"), @Index(name = "tagIdIndex", columnList = "tag_id")})
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class MediaTag extends AbstractLMI {
    @Id
    @Column(name = "media_id", columnDefinition = "bigint(20) COMMENT 'media全局唯一ID'")
    public long mediaId;
    @Id
    @Column(name = "tag_id", columnDefinition = "varchar(20) COMMENT '标签ID'")
    public String tagId;
    @Column(name = "en_tag", nullable = false, columnDefinition = "varchar(255) COMMENT 'en标签'")
    public String enTag;
    @Column(name = "category", nullable = false, columnDefinition = "int(11) COMMENT '1 plot keyword，2 other'")
    public int category;
    @Column(name = "score", nullable = false, columnDefinition = "double(11,0) DEFAULT '5' COMMENT '影片下该tags的权重'")
    public double score;

    public long getMediaId() {
        return mediaId;
    }

    public void setMediaId(long mediaId) {
        this.mediaId = mediaId;
    }

    public String getTagId() {
        return tagId;
    }

    public void setTagId(String tagId) {
        this.tagId = tagId;
    }

    public String getEnTag() {
        return enTag;
    }

    public void setEnTag(String enTag) {
        this.enTag = enTag;
    }

    public int getCategory() {
        return category;
    }

    public void setCategory(int category) {
        this.category = category;
    }

    public double getScore() {
        return score;
    }

    public void setScore(double score) {
        this.score = score;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        AbstractTag that = (AbstractTag) o;

        return Objects.equal(this.mediaId, that.mediaId) &&
            Objects.equal(this.tagId, that.tagId);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(mediaId, tagId);
    }

    @Override
    public String valueKey() {
        return DdoKeyTools.key(mediaId, tagId);
    }

    @Override
    public boolean valueEquals(Object o) {
        return equals(o);
    }
}
