package com.valor.vod.meta.model.database.ddo.media.base;

import com.google.common.base.Objects;
import com.valor.vod.api.model.constant.JobType;
import com.valor.vod.common.database.model.AbstractLMI;
import com.valor.vod.common.tools.type.DdoKeyTools;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;

/**
 * Created by Frank.Huang on 2016/4/29.
 */
@MappedSuperclass
public abstract class AbstractCastCrew extends AbstractLMI {
    @Id
    @Column(name = "media_id")
    public long mediaId;

    @Id
    @Column(name = "person_id")
    public long personId;

    @Id
    @Column(name = "job")
    public JobType jobType;

    @Column(name = "role", length = 1023)
    protected String role;

    @Column(name = "ordering", nullable = false)
    protected int ordering = 0;

    public boolean isValid() {
        if (mediaId < 1) {
            return false;
        }

        if (personId < 1) {
            return false;
        }

        //not director,actor or writer,nor add to meta
        if (!(jobType == JobType.DIRECTOR
            || jobType == JobType.ACTOR
            || jobType == JobType.WRITER)) {
            return false;
        }

        return true;
    }


    public Long getMediaId() {
        return mediaId;
    }

    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    public void setMediaId(long mediaId) {
        this.mediaId = mediaId;
    }

    public JobType getJobType() {
        return jobType;
    }

    public void setJobType(JobType jobType) {
        this.jobType = jobType;
    }

    public String getRole() {
        return role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public int getOrdering() {
        return ordering;
    }

    public void setOrdering(int ordering) {
        this.ordering = ordering;
    }

    public long getPersonId() {
        return personId;
    }

    public void setPersonId(long personId) {
        this.personId = personId;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        AbstractCastCrew that = (AbstractCastCrew) o;

        return Objects.equal(this.mediaId, that.mediaId) &&
            Objects.equal(this.personId, that.personId) &&
            Objects.equal(this.jobType, that.jobType);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(mediaId, personId, jobType);
    }

    @Override
    public String valueKey() {
        return DdoKeyTools.key(mediaId, personId, jobType);
    }

    @Override
    public boolean valueEquals(Object o) {
        if (!equals(o)) {
            return false;
        } else {
            AbstractCastCrew that = (AbstractCastCrew) o;

            return Objects.equal(this.role, that.role)
                && Objects.equal(this.ordering, that.ordering);
        }
    }
}
