package com.valor.vod.meta.model.database.ddo.media.base;

import com.google.common.base.Objects;
import com.valor.vod.common.tools.type.DdoKeyTools;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;

/**
 * Created by Frank.Huang on 2016/4/28.
 */
@MappedSuperclass
public class AbstractCertification extends AbstractId {
    @Id
    @Column(name = "country_code", length = 10, nullable = false)
    public String countryCode;

    @Column(name = "country", length = 100)
    private String country;

    @Column(name = "certificate", nullable = false)
    private String certificate;


    public String getCountry() {
        return country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getCertificate() {
        return certificate;
    }

    public void setCertificate(String certificate) {
        this.certificate = certificate;
    }

    public String getCountryCode() {
        return countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AbstractCertification that = (AbstractCertification) o;
        return Objects.equal(countryCode, that.countryCode) &&
            Objects.equal(id, that.id);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(countryCode, id);
    }

    @Override
    public String valueKey() {
        return DdoKeyTools.key(id, countryCode);
    }

    @Override
    public boolean valueEquals(Object o) {
        if (!equals(o)) {
            return false;
        } else {
            AbstractCertification that = (AbstractCertification) o;

            return Objects.equal(this.certificate, that.certificate);
        }
    }

}
