package com.valor.vod.meta.model.database.ddo.media.base;

import com.google.common.base.Objects;
import com.valor.vod.common.database.model.AbstractLMI;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;

/**
 * Created by Frank.Huang on 2016/4/29.
 */
@MappedSuperclass
public abstract class AbstractIdName extends AbstractLMI {

    @Id
    @Column(name = "id")
    public long id;

    @Column(name = "name")
    protected String name;


    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        AbstractIdName that = (AbstractIdName) o;

        return Objects.equal(this.id, that.id);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(id);
    }
}
