package com.valor.vod.meta.model.database.ddo.media.base;

import com.google.common.base.Objects;
import com.valor.vod.common.tools.type.DdoKeyTools;

import javax.persistence.MappedSuperclass;

/**
 * Created by Frank.Huang on 2016/7/26.
 */
@MappedSuperclass
public abstract class AbstractParentsGuide extends AbstractLocaleId {
    public Integer sn = 0;

    private Integer level = 0;

    private String label;

    private String publishDate;

    private String text;

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getPublishDate() {
        return publishDate;
    }

    public void setPublishDate(String publishDate) {
        this.publishDate = publishDate;
    }

    public String getText() {
        return text;
    }

    public void setText(String text) {
        this.text = text;
    }


    public Integer getSn() {
        return sn;
    }

    public void setSn(Integer sn) {
        this.sn = sn;
    }

    public Integer getLevel() {
        return level;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        AbstractParentsGuide that = (AbstractParentsGuide) o;

        return Objects.equal(this.sn, that.sn) &&
            Objects.equal(this.language, that.language) &&
            Objects.equal(this.level, that.level) &&
            Objects.equal(this.id, that.id);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(sn, language, id, level);
    }


    @Override
    public String valueKey() {
        return DdoKeyTools.key(id, language, sn, level);
    }

    @Override
    public boolean valueEquals(Object o) {
        if (!equals(o)) {
            return false;
        } else {
            AbstractParentsGuide that = (AbstractParentsGuide) o;

            return Objects.equal(this.label, that.label)
                && Objects.equal(this.publishDate, that.publishDate)
                && Objects.equal(this.text, that.text);
        }
    }
}
