package com.valor.vod.meta.model.database.ddo.media.base;

import com.google.common.base.Objects;
import com.valor.vod.meta.model.database.ddo.media.emum.EReleaseType;
import com.valor.vod.common.tools.type.DdoKeyTools;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;

/**
 * Created by Frank.Huang on 2016/4/28.
 */
@MappedSuperclass
public class AbstractReleaseInfo extends AbstractId {
    @Id
    @Column(name = "country", length = 100, nullable = false)
    public String country;

    @Id
    @Column(name = "type", length = 32)
    public EReleaseType type = EReleaseType.THEATRICAL;

    @Column(name = "release_date", nullable = false, length = 255)
    private String releaseDate;

    public String getCountry() {
        return country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getReleaseDate() {
        return releaseDate;
    }

    public void setReleaseDate(String releaseDate) {
        this.releaseDate = releaseDate;
    }

    public EReleaseType getType() {
        return type;
    }

    public void setType(EReleaseType type) {
        this.type = type;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        AbstractReleaseInfo that = (AbstractReleaseInfo) o;

        return Objects.equal(this.country, that.country) &&
            Objects.equal(this.type, that.type) &&
            Objects.equal(this.id, that.id);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(country, type, id);
    }

    @Override
    public String valueKey() {
        return DdoKeyTools.key(id, country, type);
    }

    @Override
    public boolean valueEquals(Object o) {
        if (!equals(o)) {
            return false;
        } else {
            AbstractReleaseInfo that = (AbstractReleaseInfo) o;

            return Objects.equal(this.releaseDate, that.releaseDate);
        }
    }
}
