package com.valor.vod.meta.model.database.ddo.person;

import com.google.common.base.Objects;
import com.valor.vod.common.tools.type.DdoKeyTools;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;

/**
 * Created by Frank.Huang on 2016/8/13.
 */
@MappedSuperclass
public class AbstractPersonAwardI18N extends AbstractPersonAward {
    @Id
    @Column(name = "language", length = 16)
    public String language = "";

    public String getLanguage() {
        return language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        AbstractPersonAwardI18N that = (AbstractPersonAwardI18N) o;

        return Objects.equal(this.language, that.language) &&
            Objects.equal(this.event, that.event) &&
            Objects.equal(this.category, that.category) &&
            Objects.equal(this.year, that.year) &&
            Objects.equal(this.id, that.id);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(language, event, category, year, id);
    }

    @Override
    public String valueKey() {
        return DdoKeyTools.key(language, id, year, event, category);
    }

    @Override
    public boolean valueEquals(Object o) {
        if (!super.valueEquals(o)) {
            return false;
        }

        if (!equals(o)) {
            return false;
        } else {
            AbstractPersonAwardI18N that = (AbstractPersonAwardI18N) o;
            return Objects.equal(this.language, that.language);
        }
    }
}
