package com.valor.vod.meta.model.database.ddo.person;

import com.google.common.base.Objects;
import com.valor.vod.meta.model.database.ddo.media.base.AbstractId;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

//@Entity
//@Table(name = "vms_person", indexes = {@Index(name = "pcIdIndex", columnList = "pc_id")})
//@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class Person extends AbstractId {

//    @Column(name = "vpid", length = 16)   //valor person id
    private String vpid;

//    @Column(name = "imdb_id", length = 32)   //imdb person id
    private String imdbId;

//    @Column(name = "tmdbId")   //tmdb person id
    private Long tmdbId;

//    @Column(name = "name", length = 128)
    private String name;

//    @Column(name = "first_name", length = 64)
    private String firstName;

//    @Column(name = "last_name", length = 64)
    private String lastName;


//    @Column(name = "birth_day", length = 10)
    private String birthDay;

//    @Column(name = "birth_place", length = 1023)
    private String birthPlace;

//    @Column(name = "birth_name", length = 128)
    private String birthName;

//    @Column(name = "death_day", length = 10)
    private String deathDay;

//    @Column(name = "death_place", length = 255)
    private String deathPlace;

//    @Column(name = "star_meter", columnDefinition = "int default -1")
    private int starMeter = -1;

//    @Column(name = "pc_id", length = 16)   //imdb person id
    private String pcId;

//    @Column(name = "disable", columnDefinition = "int default 0")
    private int disable;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFirstName() {
        return firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getBirthPlace() {
        return birthPlace;
    }

    public void setBirthPlace(String birthPlace) {
        this.birthPlace = birthPlace;
    }

    public String getBirthName() {
        return birthName;
    }

    public void setBirthName(String birthName) {
        this.birthName = birthName;
    }

    public String getDeathPlace() {
        return deathPlace;
    }

    public void setDeathPlace(String deathPlace) {
        this.deathPlace = deathPlace;
    }

    public String getVpid() {
        return vpid;
    }

    public void setVpid(String vpid) {
        this.vpid = vpid;
    }

    public String getImdbId() {
        return imdbId;
    }

    public void setImdbId(String imdbId) {
        this.imdbId = imdbId;
    }

    public Long getTmdbId() {
        return tmdbId;
    }

    public void setTmdbId(Long tmdbId) {
        this.tmdbId = tmdbId;
    }

    public String getBirthDay() {
        return birthDay;
    }

    public void setBirthDay(String birthDay) {
        this.birthDay = birthDay;
    }

    public String getDeathDay() {
        return deathDay;
    }

    public void setDeathDay(String deathDay) {
        this.deathDay = deathDay;
    }

    public int getStarMeter() {
        return starMeter;
    }

    public void setStarMeter(int starMeter) {
        this.starMeter = starMeter;
    }

    public String getPcId() {
        return pcId;
    }

    public void setPcId(String pcId) {
        this.pcId = pcId;
    }

    public int getDisable() {
        return disable;
    }

    public void setDisable(int disable) {
        this.disable = disable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Person that = (Person) o;

        return Objects.equal(this.id, that.id);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(id);
    }
}
