package com.valor.vod.meta.model.database.ddo.playlist;

import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import java.sql.Timestamp;

@Entity
@Table(name = "playlist_node_version")
@Data
public class PlaylistNodeVersionDDO {
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Id
    @Column(name = "id")
    private Long id;

    @Column(name = "playlist_node_id")
    private Long playlistNodeId;

    @Column(name = "version")
    private Long version;

    @Column(name = "status")
    private Byte status;

    @Column(name = "act")
    private Byte act;

    @Column(name = "create_time", insertable = false, updatable = false)
    private Timestamp createTime;

    @Column(name = "update_time", insertable = false, updatable = false)
    private Timestamp updateTime;
}
