package com.valor.vod.meta.model.database.ddo.playlist;

import com.valor.vod.api.model.tag.ETagContentType;
import com.valor.vod.api.model.tag.ETagPostion;
import com.valor.vod.api.model.tag.ETagType;
import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;

/**
 * playlist tag表
 *
 * @author Damon.Gao
 * @date 2021/7/27 16:03
 */
@Entity
@Data
@Table(name = "playlist_tag")
public class PlaylistTagDDO implements Serializable {

    @Id
    @Column(name = "node_id")
    private Long nodeId;

    @Id
    @Column(name = "product_id")
    private Long productId;

    @Id
    @Column(name = "position")
    @Enumerated(EnumType.STRING)
    private ETagPostion position;

    @Column(name = "seq")
    private Integer seq;

    @Column(name = "content")
    private String content;

    @Column(name = "content_filter")
    private String contentFilter;

    @Column(name = "content_from")
    private String contentFrom;

    @Column(name = "content_type")
    @Enumerated(EnumType.STRING)
    private ETagContentType contentType;

    @Column(name = "type")
    @Enumerated(EnumType.STRING)
    private ETagType type;

    @Column(name = "acl")
    private String acl;

    @Column(name = "data_type")
    private String dataType;

}
