package com.valor.vod.meta.model.database.ddo.playlist.intheater;

import com.google.common.base.Objects;
import com.valor.vod.api.model.constant.EVideoType;
import com.valor.vod.meta.model.database.ddo.media.base.AbstractId;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

import javax.persistence.*;

/**
 * Created by Frank.Huang on 2016/7/23.
 */
//@Entity
//@Table(name = "vms_movie_in_theater")
//@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class MovieInTheater extends AbstractId {
    //avoid hibernate bug when L2 cache PUT failed,change to public
//    @Id
//    @Column(name = "region", length = 16)
    public String region = "";

//    @Id
//    @Column(name = "language", length = 16)
    public String language = "";
//    @Column(name = "media_type")
    public EVideoType mediaType;
//    @Column(name = "release_date_int")
    private int releaseDateInt = 0;
//    @Column(name = "imdb_id", length = 16)
    private String imdbId;
    @Transient
    private int linked = 0;
//    @Column(name = "locale_title", length = 1024)
    private String localeTitle;

//    @Column(name = "status")
    private int status = 0;

//    @Column(name = "locale_release_date")
    private int localeReleaseDateInt = 0;

    public String getRegion() {
        return region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getLanguage() {
        return language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public int getReleaseDateInt() {
        return releaseDateInt;
    }

    public void setReleaseDateInt(int releaseDateInt) {
        this.releaseDateInt = releaseDateInt;
    }

    public String getImdbId() {
        return imdbId;
    }

    public void setImdbId(String imdbId) {
        this.imdbId = imdbId;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        MovieInTheater that = (MovieInTheater) o;

        return Objects.equal(this.region, that.region) &&
            Objects.equal(this.language, that.language) &&
            Objects.equal(this.id, that.id);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(region, language, id);
    }

    public int getLinked() {
        return linked;
    }

    public void setLinked(int linked) {
        this.linked = linked;
    }

    public EVideoType getMediaType() {
        return mediaType;
    }

    public void setMediaType(EVideoType mediaType) {
        this.mediaType = mediaType;
    }

    public String getLocaleTitle() {
        return localeTitle;
    }

    public void setLocaleTitle(String localeTitle) {
        this.localeTitle = localeTitle;
    }

    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getLocaleReleaseDateInt() {
        return localeReleaseDateInt;
    }

    public void setLocaleReleaseDateInt(int localeReleaseDateInt) {
        this.localeReleaseDateInt = localeReleaseDateInt;
    }
}
