package com.valor.vod.meta.model.database.dto;

import com.google.common.base.Strings;
import com.valor.vod.common.database.model.IComparable;
import com.valor.vod.meta.model.database.ddo.media.base.AbstractArtwork;

/**
 * Created by Frank.Huang on 2016/6/22.
 */
public class ArtworkChangedMerge implements IChangedMerge {
    @Override
    public void onMerge(IComparable oldValue, IComparable newValue) {
        if (oldValue == null || newValue == null) {
            return;
        }

        //新artwork的url为空,继续使用旧的url
        if ((oldValue instanceof AbstractArtwork) && (newValue instanceof AbstractArtwork)) {
            AbstractArtwork oldArtwork = (AbstractArtwork) oldValue;
            AbstractArtwork newArtwork = (AbstractArtwork) newValue;
            if (Strings.isNullOrEmpty(newArtwork.getUrl())) {
                newArtwork.setUrl(oldArtwork.getUrl());
            }
        }
    }
}
