package com.valor.vod.meta.model.database.dto;

import com.google.common.collect.Sets;
import com.valor.vod.meta.model.database.ddo.media.tv.Season;
import com.valor.vod.meta.model.database.ddo.media.tv.Series;
import com.valor.vod.meta.model.database.ddo.media.tv.SeriesLocale;
import com.valor.vod.meta.model.database.ddo.media.video.*;

import java.util.Set;

/**
 * Created by Frank.Huang on 2016/5/7.
 */
public class VideoMetaDto {
    private Video video;
    private VideoLocale videoLocale;

    private Series series;
    private SeriesLocale seriesLocale;
    private Set<Season> seasons = Sets.newHashSet();

    private Set<VideoTrailer> trailers = Sets.newHashSet();
    private Set<VideoArtwork> artworks = Sets.newHashSet();
    private Set<VideoSynopsis> synopsises = Sets.newHashSet();
    private Set<VideoUserReview> userReviews = Sets.newHashSet();

    private Set<VideoGenre> genres = Sets.newHashSet();
    private Set<VideoCountry> countries = Sets.newHashSet();
    private Set<VideoCertification> certs = Sets.newHashSet();
    private Set<VideoSimilar> similors = Sets.newHashSet();
    private Set<VideoReleaseInfo> releaseInfos = Sets.newHashSet();
    private Set<VideoCastCrew> casts = Sets.newHashSet();
    private Set<VideoTitleAKA> titleAkas = Sets.newHashSet();
    private Set<VideoAward> awards = Sets.newHashSet();
    private Set<PersonDto> persons = Sets.newHashSet();


    public boolean isInvaild() {
        return (video == null && series == null);
    }

    public Video getVideo() {
        return video;
    }

    public void setVideo(Video video) {
        this.video = video;
    }

    public VideoLocale getVideoLocale() {
        return videoLocale;
    }

    public void setVideoLocale(VideoLocale videoLocale) {
        this.videoLocale = videoLocale;
    }

    public Set<VideoTrailer> getTrailers() {
        return trailers;
    }

    public void setTrailers(Set<VideoTrailer> trailer) {
        this.trailers = trailer;
    }

    public Set<VideoArtwork> getArtworks() {
        return artworks;
    }

    public void setArtworks(Set<VideoArtwork> artwork) {
        this.artworks = artwork;
    }

    public Set<VideoSynopsis> getSynopsises() {
        return synopsises;
    }

    public void setSynopsises(Set<VideoSynopsis> synopsises) {
        this.synopsises = synopsises;
    }

    public Set<VideoUserReview> getUserReviews() {
        return userReviews;
    }

    public void setUserReviews(Set<VideoUserReview> userReviews) {
        this.userReviews = userReviews;
    }

    public Set<VideoGenre> getGenres() {
        return genres;
    }

    public void setGenres(Set<VideoGenre> genres) {
        this.genres = genres;
    }

    public Set<VideoCountry> getCountries() {
        return countries;
    }

    public void setCountries(Set<VideoCountry> countries) {
        this.countries = countries;
    }

    public Set<VideoCertification> getCerts() {
        return certs;
    }

    public void setCerts(Set<VideoCertification> certs) {
        this.certs = certs;
    }

    public Set<VideoSimilar> getSimilors() {
        return similors;
    }

    public void setSimilors(Set<VideoSimilar> similors) {
        this.similors = similors;
    }

    public Set<VideoReleaseInfo> getReleaseInfos() {
        return releaseInfos;
    }

    public void setReleaseInfos(Set<VideoReleaseInfo> releaseInfos) {
        this.releaseInfos = releaseInfos;
    }

    public Set<VideoCastCrew> getCasts() {
        return casts;
    }

    public void setCasts(Set<VideoCastCrew> casts) {
        this.casts = casts;
    }

    public Set<PersonDto> getPersons() {
        return persons;
    }

    public void setPersons(Set<PersonDto> persons) {
        this.persons = persons;
    }

    public Set<VideoTitleAKA> getTitleAkas() {
        return titleAkas;
    }

    public void setTitleAkas(Set<VideoTitleAKA> titleAkas) {
        this.titleAkas = titleAkas;
    }

    public Set<VideoAward> getAwards() {
        return awards;
    }

    public void setAwards(Set<VideoAward> awards) {
        this.awards = awards;
    }

    public Series getSeries() {
        return series;
    }

    public void setSeries(Series series) {
        this.series = series;
    }

    public SeriesLocale getSeriesLocale() {
        return seriesLocale;
    }

    public void setSeriesLocale(SeriesLocale seriesLocale) {
        this.seriesLocale = seriesLocale;
    }

    public Set<Season> getSeasons() {
        return seasons;
    }

    public void setSeasons(Set<Season> seasons) {
        this.seasons = seasons;
    }
}
