package com.valor.vod.meta.model.database.dto;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.valor.vod.meta.model.database.constants.EMetaProperty;
import com.valor.vod.meta.model.database.constants.MMDataFlag;
import com.valor.vod.meta.model.database.ddo.media.MediaTag;
import com.valor.vod.meta.model.database.ddo.media.video.*;
import com.valor.vod.meta.model.database.ddo.person.PersonFilmography2;
import com.valor.vod.meta.model.database.tools.BitTools;
import org.apache.commons.lang3.StringUtils;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import static common.base.tools.type.CollectionUtils.isNullOrEmpty;

/**
 * Created by Frank.Huang on 2016/5/7.
 */
public class VideoMetaDto4Merge extends MetaMergeDto {
    private Video video;
    //    private VideoLocale videoLocale;
    private Map<String, VideoLocale> videoLocales = Maps.newHashMap();

    private Map<String, VideoTrailer> trailers = Maps.newHashMap();
    private Map<String, VideoArtwork> artworks = Maps.newHashMap();
    private Map<String, VideoSynopsis> synopsises = Maps.newHashMap();
    private Map<String, VideoUserReview> userReviews = Maps.newHashMap();
    private Map<String, VideoGenre> genres = Maps.newHashMap();
    private Map<String, VideoCountry> countries = Maps.newHashMap();
    private Map<String, VideoCertification> certs = Maps.newHashMap();
    private Map<String, VideoSimilar> similars = Maps.newHashMap();
    private Map<String, VideoReleaseInfo> releaseInfos = Maps.newHashMap();
    private Map<String, VideoCastCrew> casts = Maps.newHashMap();
    private Map<String, VideoTitleAKA> titleAkas = Maps.newHashMap();
    private Map<String, VideoAward> awards = Maps.newHashMap();
    private Map<String, PersonDto> persons = Maps.newHashMap();
    private Map<String, VideoParentsGuide> parentsGuides = Maps.newHashMap();
    private Map<String, VideoAttribute> attributes = Maps.newHashMap();
    private Map<String, PersonFilmography2> filmographies = Maps.newHashMap();
    private Map<String, VideoCompany> companies = Maps.newHashMap();
    private Map<String, MediaTag> tags = Maps.newHashMap();
    private Set<String> subtitles = Sets.newHashSet();

    public VideoMetaDto4Merge(String field) {
        super(field);
    }

    public Set<String> getSubtitles() {
        return subtitles;
    }

    public void setSubtitles(Set<String> subtitles) {
        this.subtitles = subtitles;
    }

    public boolean isInvaild() {
        return (video == null);
    }

    public Video getVideo() {
        return video;
    }


    public void setVideo(Video video) {
        setVideo(video, false);
    }

    public void setVideo(Video video, boolean update) {
        if (video != null && this.video != null) {
            if (!Strings.isNullOrEmpty(this.video.getMetaId())) {
                video.setMetaId(this.video.getMetaId());
            }

            if (this.video.getManual() > 0) {
                video.setManual(this.video.getManual());
            }

            if (this.video.getManual() > 0) {
                video.setManual(this.video.getManual());
            }

            if (BitTools.isSet(this.getVideo().getComplete(), EMetaProperty.META_DUPLICATE.getValue())) {
                video.setComplete(video.getComplete() | EMetaProperty.META_DUPLICATE.getValue());
            }

            if (BitTools.isSet(this.getVideo().getComplete(), EMetaProperty.META_PORNOGRAPHIC.getValue())) {
                video.setComplete(video.getComplete() | EMetaProperty.META_PORNOGRAPHIC.getValue());
            }
        }

        this.video = video;
        if (update) {
            meta4QueryWrapper.updateMetaFlag(this.video);
        }
        addChanged(video);
    }

    public Set<VideoLocale> getVideoLocales() {
        return mapValueAsSet(this.videoLocales);
    }

    public void setVideoLocales(Set<VideoLocale> videoLocales) {
        if (isNullOrEmpty(videoLocales)) {
            return;
        }
        Set<VideoLocale> videoLocaleNoManualedSet = videoLocales.stream().filter(e -> StringUtils.isNotBlank(e.valueKey()) && e.getDataVersion() != MMDataFlag.DETA_MM_VERSION).collect(Collectors.toSet());
        setAll(this.videoLocales, videoLocaleNoManualedSet);
    }

    public Set<VideoTrailer> getTrailers() {
        return mapValueAsSet(this.trailers);
    }

    public void setTrailers(Set<VideoTrailer> trailers) {
        setAll(this.trailers, trailers);
    }

    public void addTrailers(Set<VideoTrailer> trailers) {
        addAllIfChange(this.trailers, trailers);
    }


    public Set<VideoArtwork> getArtworks() {
        return mapValueAsSet(this.artworks);
    }

    public void setArtworks(Set<VideoArtwork> artworks) {
        updateArtworkModifyFlag(artworks, modifyFlagWrapper);
        setAll(this.artworks, artworks);
    }

    public void addArtworks(Set<VideoArtwork> artworks) {
        addAllIfChange(this.artworks, artworks, new ArtworkChangedMerge());
        meta4QueryWrapper.updateArtworkFlag(artworks, modifyFlagWrapper);
    }

    public Set<VideoSynopsis> getSynopsises() {
        return mapValueAsSet(this.synopsises);
    }

    public void setSynopsises(Set<VideoSynopsis> synopsises) {
        setAll(this.synopsises, synopsises);
    }

    public void addSynopsises(Set<VideoSynopsis> synopsises) {
        addAllIfChange(this.synopsises, synopsises);
    }

    public Set<VideoUserReview> getUserReviews() {
        return mapValueAsSet(this.userReviews);
    }

    public void setUserReviews(Set<VideoUserReview> userReviews) {
        setAll(this.userReviews, userReviews);
    }

    public void addUserReviews(Set<VideoUserReview> userReviews) {
        addAllIfChange(this.userReviews, userReviews);
    }


    public Set<VideoGenre> getGenres() {
        return mapValueAsSet(this.genres);

    }

    public void setGenres(Set<VideoGenre> genres) {
        setAll(this.genres, genres);
    }

    public void addGenres(Set<VideoGenre> genres) {
        addAllIfChange(this.genres, genres);
        meta4QueryWrapper.updateGenreFlag(genres);
    }


    public Set<VideoCountry> getCountries() {
        return mapValueAsSet(this.countries);
    }


    public void setCountries(Set<VideoCountry> countries) {
        setAll(this.countries, countries);
        meta4QueryWrapper.updateRegionFlag(countries);
    }

    public void addCountries(Set<VideoCountry> countries) {
        addAllIfChange(this.countries, countries);
    }

    public Set<VideoCertification> getCerts() {
        return mapValueAsSet(this.certs);
    }

    public void setCerts(Set<VideoCertification> certs) {
        setAll(this.certs, certs);
    }

    public void addCerts(Set<VideoCertification> certs) {
        addAllIfChange(this.certs, certs);
        meta4QueryWrapper.updateCertFlag(certs);
    }

    public Set<VideoSimilar> getSimilars() {
        return mapValueAsSet(this.similars);
    }

    public void setSimilars(Set<VideoSimilar> similars) {
        setAll(this.similars, similars);
    }

    public void addSimilars(Set<VideoSimilar> similars) {
        addAllIfChange(this.similars, similars);
    }


    public Set<VideoReleaseInfo> getReleaseInfos() {
        return mapValueAsSet(this.releaseInfos);
    }

    public void setReleaseInfos(Set<VideoReleaseInfo> releaseInfos) {
        setAll(this.releaseInfos, releaseInfos);
    }

    public void addReleaseInfos(Set<VideoReleaseInfo> releaseInfos) {
        addAllIfChange(this.releaseInfos, releaseInfos);
    }

    public Set<VideoCastCrew> getCasts() {
        return mapValueAsSet(this.casts);
    }

    public void setCasts(Set<VideoCastCrew> casts) {
        setAll(this.casts, casts);
    }

    public void addCasts(Set<VideoCastCrew> casts) {
        addAllIfChange(this.casts, casts);
    }

    public Set<PersonDto> getPersons() {
        return Sets.newHashSet(this.persons.values());
    }

    public void setPersons(Set<PersonDto> persons) {
//        if (!CollectionUtils.isNullOrEmpty(persons)){
//            persons.forEach(e->{
//                this.persons.put(e.valueKey(), e);
//            });
//        }
    }

    public Set<VideoTitleAKA> getTitleAkas() {
        return mapValueAsSet(this.titleAkas);
    }

    public void setTitleAkas(Set<VideoTitleAKA> titleAkas) {
        setAll(this.titleAkas, titleAkas);
    }

    public void addTitleAkas(Set<VideoTitleAKA> titleAkas) {
        addAllIfChange(this.titleAkas, titleAkas);
    }

    public Set<VideoAward> getAwards() {
        return mapValueAsSet(this.awards);
    }

    public void setAwards(Set<VideoAward> awards) {
        setAll(this.awards, awards);
    }

    public void addAwards(Set<VideoAward> awards) {
        addAllIfChange(this.awards, awards);
    }


    public Set<VideoParentsGuide> getParentsGuides() {
        return mapValueAsSet(this.parentsGuides);
    }

    public void setParentsGuides(Set<VideoParentsGuide> valueSet) {
        setAll(this.parentsGuides, valueSet);
    }

    public void addParentsGuides(Set<VideoParentsGuide> valueSet) {
        addAllIfChange(this.parentsGuides, valueSet);
    }

    public Set<VideoAttribute> getAttribute() {
        return mapValueAsSet(this.attributes);
    }

    public void setAttribute(Set<VideoAttribute> valueSet) {
        setAll(this.attributes, valueSet);
    }

    public void addAttribute(Set<VideoAttribute> valueSet) {
        addAllIfChange(this.attributes, valueSet);
    }

    public void addAttribute(VideoAttribute v) {
        addIfChange(this.attributes, v, null);
    }

    public Set<PersonFilmography2> getFilmographies() {
        return mapValueAsSet(this.filmographies);
    }

    public void setFilmographies(Set<PersonFilmography2> filmographies) {
        setAll(this.filmographies, filmographies);
    }

    public void addFilmographies(Set<PersonFilmography2> filmographies) {
        addAllIfChange(this.filmographies, filmographies);
    }

    public Set<VideoCompany> getCompanies() {
        return mapValueAsSet(this.companies);
    }

    public void setCompanies(Set<VideoCompany> companies) {
        setAll(this.companies, companies);
    }

    public void addCompanies(Set<VideoCompany> companies) {
        addAllIfChange(this.companies, companies);
    }

    public Set<MediaTag> getTags() {
        return mapValueAsSet(this.tags);
    }

    public void setTags(Set<MediaTag> tags) {
        setAll(this.tags, tags);
    }

    public void addTags(Set<MediaTag> tags) {
        addAllIfChange(this.tags, tags);
    }

    @Override
    public Set<Object> getToBeDelSet() {
        setToBeDel(trailers);
        setToBeDel(artworks);
        setToBeDel(synopsises);
        setToBeDel(userReviews);
        setToBeDel(genres);
        setToBeDel(countries);
        setToBeDel(certs);
        setToBeDel(similars);
        setToBeDel(releaseInfos);
        setToBeDel(casts);
        setToBeDel(titleAkas);
        setToBeDel(awards);
        setToBeDel(parentsGuides);
        setToBeDel(attributes);
        setToBeDel(filmographies);
        setToBeDel(companies);
        setToBeDel(tags);

        return super.getToBeDelSet();
    }
}
