package com.valor.vod.meta.model.database.tools.playlist;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.valor.vod.meta.model.database.constants.EAwardCategory;
import com.valor.vod.meta.model.database.constants.EAwardEvent;

import java.util.Set;

/**
 * Created by Frank.Huang on 2016/6/15.
 */
@Deprecated
public class AwardTools {
    public static final int AWARD_PLAYLIST_ID_BASE = 10000;
    public static final int AWARD_PLAYLIST_ID_MIN = 100000;
    public static final int AWARD_PLAYLIST_ID_MAX = 1 + AWARD_PLAYLIST_ID_MIN + EAwardEvent.END.ordinal() * AWARD_PLAYLIST_ID_BASE;

    public static final String OSCAR_BEST_FOREIGN_FILM = "Best Foreign Language Film of the Year";
    public static final String OSCAR_BEST_FILM = "Best Motion Picture of the Year";
    public static final String OSCAR_BEST_FILM_2005 = "Best Picture";
    public static final String OSCAR_BEST_FILM_1929 = "Best Picture, Production";
    public static final String OSCAR_BEST_FOREIGN_FILM_2005 = "Best Foreign Language Film";


    public static final String GOLDEN_GLOBE_BEST_FILM = "Best Motion Picture - Drama";
    public static final String GOLDEN_GLOBE_BEST_FOREIGN_FILM = "Best Motion Picture - Foreign Language";
    public static final String BAFTA_FILM = "Best Film";
    public static final String BAFTA_BEST_FOREIGN_FILM = "Best Film not in the English Language";
    public static final String GOLDEN_LION_BEST_FILE = "-1";
    public static final String GOLDEN_BERLIN_BEAR_BEST_FILM = "-1";
    public static final String GOLDEN_BERLIN_BEAR_BEST_FILM_V2 = "Best Film";
    public static final String PALME_DOR_BEST_FILM = "-1";
    public static final String EMMY_AWARDS_BEST_SERIES = "Outstanding Drama Series";
    public static final String TEEN_CHOICE_AWARDS_BEST_FILM = "Choice Movie: Drama";


    public static final String EVENT_EMMY_AWARDS = "Primetime Emmy";
    public static final String EVENT_OSCAR = "Oscar";
    public static final String EVENT_GOLDEN_GLOBE = "Golden Globe";
    public static final String EVENT_BAFTA_FILM_AWARD = "BAFTA Film Award";
    public static final String EVENT_BAFTA_TV_AWARD = "BAFTA TV Award";

    public static final String EVENT_GOLDEN_LION = "Golden Lion";
    public static final String EVENT_GOLDEN_BERLIN_BEAR = "Golden Berlin Bear";
    public static final String EVENT_PALME_DOR = "Palme d'Or";
    public static final String EVENT_TEEN_CHOICE_AWARD = "Teen Choice Award";


    public static final String ORGANIZED_EMMY_AWARDS = "Primetime Emmy Awards";
    public static final String ORGANIZED_OSCAR = "Academy Awards";
    public static final String ORGANIZED_GOLDEN_GLOBE = "Golden Globes";
    public static final String ORGANIZED_BAFTA_FILM_AWARD = "BAFTA Awards";
    public static final String ORGANIZED_BAFTA_TV_AWARD = "BAFTA Awards";
    public static final String ORGANIZED_GOLDEN_LION = "Venice Film Festival";
    public static final String ORGANIZED_GOLDEN_BERLIN_BEAR = "Berlin International Film Festival";
    public static final String ORGANIZED_PALME_DOR = "Cannes Film Festival";
    public static final String ORGANIZED_TEEN_CHOICE_AWARD = "Teen Choice Awards";
    /*
    -------------------------------------------------------------------------------
    |EVENT                  ORGANIZED                       CATEGORY
    -------------------------------------------------------------------------------
    Oscar	            Academy Awards	                    Best Motion Picture of the Year
			                                                Best Foreign Language Film of the Year
                                                            Best Picture
                                                            Best Foreign Language Film


	Golden Globe	    Golden Globes	                    Best Motion Picture - Drama
			                                                Best Motion Picture - Foreign Language

	BAFTA Film award	BAFTA Awards	                    Best Film
			                                                Best Film not in the English Language

	Golden Lion	        Venice Film Festival                Best Film
	Golden Berlin Bear	Berlin International Film Festival	Best Film
	Palme d'Or	        Cannes Film Festival	            Best Film

	Primetime Emmy	    Primetime Emmy Awards	             Outstanding Drama Series
*/

    public static boolean isAwardPlaylist(long playlistId) {
        return (playlistId >= AWARD_PLAYLIST_ID_MIN && playlistId < AWARD_PLAYLIST_ID_MAX);
    }

    public static String getEventName(EAwardEvent evennt) {
        switch (evennt) {
            case OSCAR:
                return EVENT_OSCAR;
            case EMMY_AWARDS:
                return EVENT_EMMY_AWARDS;
            case GOLDEN_GLOBE:
                return EVENT_GOLDEN_GLOBE;
            case BAFTA_FILM_AWARD:
                return EVENT_BAFTA_FILM_AWARD;
            case BAFTA_TV_AWARD:
                return EVENT_BAFTA_TV_AWARD;
            case GOLDEN_LION:
                return EVENT_GOLDEN_LION;
            case GOLDEN_BERLIN_BEAR:
                return EVENT_GOLDEN_BERLIN_BEAR;
            case PALME_DOR:
                return EVENT_PALME_DOR;
            case TEEN_CHOICE_AWARDS:
                return EVENT_TEEN_CHOICE_AWARD;

            default:
                return "";
        }
    }

    public static Set<String> getCategoryByEvent(EAwardEvent evennt) {
        switch (evennt) {
            case OSCAR:
                return ImmutableSet.<String>builder()
                    .add(OSCAR_BEST_FILM)
                    .add(OSCAR_BEST_FILM_2005)
                    .add(OSCAR_BEST_FILM_1929)
                    .add(OSCAR_BEST_FOREIGN_FILM)
                    .add(OSCAR_BEST_FOREIGN_FILM_2005)
                    .add()
                    .build();

            case GOLDEN_GLOBE:
                return ImmutableSet.<String>builder()
                    .add(GOLDEN_GLOBE_BEST_FILM)
                    .add(GOLDEN_GLOBE_BEST_FOREIGN_FILM)
                    .build();
            case BAFTA_FILM_AWARD:
            case BAFTA_TV_AWARD:
                return ImmutableSet.<String>builder()
                    .add(BAFTA_FILM)
                    .add(BAFTA_BEST_FOREIGN_FILM)
                    .build();
            case EMMY_AWARDS:
                return ImmutableSet.<String>builder()
                    .add("Outstanding Drama Series")
                    .add("Outstanding Casting for a Drama Series")
                    .add("Outstanding Comedy Series")
                    .add("Outstanding Casting for a Comedy Series")
                    .add("Outstanding Limited Series")
                    .add("Outstanding Casting for a Limited Series, Movie or Special")
                    .add("Outstanding Television Movie")
                    .add("Outstanding Reality Competition Program")
                    .add("Outstanding Host for a Reality or Reality-Competition Program")
                    .add("Outstanding Variety Sketch Series")
                    .add("Outstanding Structured Reality Program")
                    .add("Outstanding Unstructured Reality Program")
                    .add("Outstanding Documentary or Nonfiction Special")
                    .add("Outstanding Documentary or Nonfiction Series")
                    .add("Outstanding Informational Series or Special")
                    .build();
            case GOLDEN_LION:
                return ImmutableSet.<String>builder()
                    .add(GOLDEN_LION_BEST_FILE)
                    .add("Best Film")
                    .build();
            case GOLDEN_BERLIN_BEAR:
                return ImmutableSet.<String>builder()
                    .add(GOLDEN_BERLIN_BEAR_BEST_FILM)
                    .add("Best Film")
                    .build();
            case PALME_DOR:
                return ImmutableSet.<String>builder()
                    .add(PALME_DOR_BEST_FILM)
                    .add("")
                    .build();
            case TEEN_CHOICE_AWARDS:
                return ImmutableSet.<String>builder()
                    .add(TEEN_CHOICE_AWARDS_BEST_FILM)
                    .build();
            default:
                return Sets.newHashSet();
        }
    }

    public static String getOrganizedByEvent(EAwardEvent evennt) {
        switch (evennt) {
            case OSCAR:
                return ORGANIZED_OSCAR;
            case EMMY_AWARDS:
                return ORGANIZED_EMMY_AWARDS;
            case GOLDEN_GLOBE:
                return ORGANIZED_GOLDEN_GLOBE;
            case BAFTA_FILM_AWARD:
                return ORGANIZED_BAFTA_FILM_AWARD;
            case BAFTA_TV_AWARD:
                return ORGANIZED_BAFTA_TV_AWARD;
            case GOLDEN_LION:
                return ORGANIZED_GOLDEN_LION;
            case GOLDEN_BERLIN_BEAR:
                return ORGANIZED_GOLDEN_BERLIN_BEAR;
            case PALME_DOR:
                return ORGANIZED_PALME_DOR;
            case TEEN_CHOICE_AWARDS:
                return ORGANIZED_TEEN_CHOICE_AWARD;
            default:
                return "";
        }
    }

    public static String getBackdrop(EAwardEvent evennt) {
        switch (evennt) {
            case OSCAR:
                return "opt/playlist/oscar-backdrop.jpg";
            case EMMY_AWARDS:
                return "opt/playlist/emmy_bp.jpg";
            case GOLDEN_GLOBE:
                return "opt/playlist/golden_globe_backdrop.jpg";
            case BAFTA_FILM_AWARD:
                return "opt/playlist/bafta_backdrop.jpg";
            case BAFTA_TV_AWARD:
                return "opt/playlist/bafta_backdrop.jpg";
            case GOLDEN_LION:
                return "opt/playlist/golden_lion_backup.jpg";
            case GOLDEN_BERLIN_BEAR:
                return "opt/playlist/bolden_berlin_bear_bcakdrop.jpg";
            case PALME_DOR:
                return "opt/playlist/palme_dor_cannes_backdrop.jpg";
            case TEEN_CHOICE_AWARDS:
                return "opt/playlist/awardcenter/TeenChiceAwards_backdrop.png";
            default:
                return "";
        }
    }

    public static String getImgTag(EAwardEvent evennt, String position) {
        switch (evennt) {
            case OSCAR:
                return "opt/playlist/imgtag/award/" + position + "_oscar.png";
            case EMMY_AWARDS:
                return "opt/playlist/imgtag/award/" + position + "_primetime_emmy.png";
            case GOLDEN_GLOBE:
                return "opt/playlist/imgtag/award/" + position + "_golden_globe.png";
            case BAFTA_FILM_AWARD:
                return "opt/playlist/imgtag/award/" + position + "_bafta_film_award.png";
            case BAFTA_TV_AWARD:
                return "opt/playlist/imgtag/award/" + position + "_bafta_tv_award.png";
            case GOLDEN_LION:
                return "opt/playlist/imgtag/award/" + position + "_golden_lion.png";
            case GOLDEN_BERLIN_BEAR:
                return "opt/playlist/imgtag/award/" + position + "_golden_berlin_bear.png";
            case PALME_DOR:
                return "opt/playlist/imgtag/award/" + position + "_palme_dor.png";
            case TEEN_CHOICE_AWARDS:
                return "opt/playlist/imgtag/award/" + position + "_teen_choice_award.png";
            default:
                return "";
        }
    }


    public static int getPid(EAwardEvent evennt, int year) {
        return AWARD_PLAYLIST_ID_MIN + (evennt.ordinal() * AWARD_PLAYLIST_ID_BASE + year);
    }

    public static EAwardCategory getCategory(EAwardEvent evennt, String category) {
        switch (evennt) {
            case OSCAR:
                if (OSCAR_BEST_FILM.equalsIgnoreCase(category)
                    || OSCAR_BEST_FILM_2005.equalsIgnoreCase(category)
                    || OSCAR_BEST_FILM_1929.equalsIgnoreCase(category)) {
                    return EAwardCategory.BEST_FILM;
                } else if (OSCAR_BEST_FOREIGN_FILM.equalsIgnoreCase(category)
                    || OSCAR_BEST_FOREIGN_FILM_2005.equalsIgnoreCase(category)) {
                    return EAwardCategory.BEST_FOREIGN_FILM;
                } else {
                    return EAwardCategory.UNKNOWN;
                }

            case GOLDEN_GLOBE:
                if (GOLDEN_GLOBE_BEST_FILM.equalsIgnoreCase(category)) {
                    return EAwardCategory.BEST_FILM;
                } else if (GOLDEN_GLOBE_BEST_FOREIGN_FILM.equalsIgnoreCase(category)) {
                    return EAwardCategory.BEST_FOREIGN_FILM;
                } else {
                    return EAwardCategory.UNKNOWN;
                }


            case BAFTA_FILM_AWARD:
            case BAFTA_TV_AWARD:
                if (BAFTA_FILM.equalsIgnoreCase(category)) {
                    return EAwardCategory.BEST_FILM;
                } else if (BAFTA_BEST_FOREIGN_FILM.equalsIgnoreCase(category)) {
                    return EAwardCategory.BEST_FOREIGN_FILM;
                } else {
                    return EAwardCategory.UNKNOWN;
                }

            case GOLDEN_LION:
                return EAwardCategory.BEST_FILM;
            case GOLDEN_BERLIN_BEAR:
                return EAwardCategory.BEST_FILM;
            case PALME_DOR:
                return EAwardCategory.BEST_FILM;
            case TEEN_CHOICE_AWARDS:
                return EAwardCategory.BEST_DRAMA_FILM;
            default:
                return EAwardCategory.UNKNOWN;
        }
    }

    public static String getExtra(EAwardEvent event) {
        return new StringBuilder()
            .append("awardOrder=")
            .append(getEventName(event))
            .append("|")
            .append("&imgTagLT=")
            .append(getImgTag(event, "lt"))
            .toString();
    }


    public static String buildImgTagFilter(EAwardEvent event) {
        return new StringBuilder().append("event:=|").append(getEventName(event))
            .append(";").append("category:in|").append(Joiner.on("#").skipNulls().join(getCategoryByEvent(event)))
            .append(";").append("won:=|1")
            .toString();

    }

    public static String buildTxtTagFilter(EAwardEvent event) {
        return new StringBuilder().append("event:=|").append(getEventName(event))
            .append(";").append("category:in|").append(Joiner.on("#").skipNulls().join(getCategoryByEvent(event)))
            .toString();

    }
}

