package com.valor.vod.meta.model.database.tools.playlist;

import com.valor.vod.meta.model.database.constants.playlist.EPlaylistRefListSubType;

/**
 * playlist id生成工具
 *
 * @author Damon.Gao
 * @date 2021/7/28 11:05
 */
public class PlaylistIdTools {

    public static final Long BASE = 100_0000_0000L;

    private static final Long RATIO = 1_0000_0000L;

    private static final String ALPHABET_REGEX = "[a-zA-Z]+";

    private static final String REPLACEMENT = "";

    public static final Long OPEN_API_BASE = 400_0000_0000L;

    /**
     * 生成规则：
     *  base + EPlaylistSourceType.getFactor * ratio + (id去掉字母后的值)
     *
     * @param originId 原始的ID
     * @param type subtype
     * @return vmsId
     */
    public static Long getId(String originId, EPlaylistRefListSubType type) {
        originId = originId.replaceAll(ALPHABET_REGEX, REPLACEMENT);
        return BASE + type.getFactor() * RATIO + Long.parseLong(originId);
    }

}