package com.valor.vod.meta.model.database.tools.playlist;

/**
 * playlist 排序工具类
 *
 * @author Damon.Gao
 * @date 2021/7/28 17:32
 */
public class PlaylistSortTools {

    private static final Integer AWARD_SORT_THRESHOLD = 10_0000;

    private static final Integer SERIES_SORT_THRESHOLD = 10000;

    public static Integer getAwardSortNo(int year) {
        return AWARD_SORT_THRESHOLD - year;
    }

    public static Integer getTopicSortNo(int pos) {
        return pos;
    }

    public static Integer getSeriesSortNo(int pos) {
        return SERIES_SORT_THRESHOLD - pos;
    }

    /**
     * 规则：((100-年份)* 10000 + (12-月份) * 100 + (31-天数)) * 1000 + 999 - delta
     * 该方法仅支持到2100年内的排序。^_^
     * 该方法仅支持一天内最多有999部series更新，超过数量后，会导致列表内数据丢失。:(
     * @param releaseDate 发布日期，格式必须是yyyy-MM-dd，其他格式会报错
     * @param delta 同一天发布series的差量数字，每次请求该方法，delta单调增（由请求方保证）
     * @return 在OnTheAir列表里的排序，发布日期越新，排序值越小；同一天发布的，后请求该方法的，排序值越小。
     */
    public static Integer getOnTheAirSortNo(String releaseDate, int delta) {
        int year = Integer.parseInt(releaseDate.substring(0, 4));
        int month = Integer.parseInt(releaseDate.substring(5, 7));
        int day = Integer.parseInt(releaseDate.substring(8));
        int prefix = (2100 - year) * 10000 + (12 - month) * 100 + (31 - day);
        return prefix * 1000 + 999 - delta;
    }
}
