/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.meta.model.database.dao.query.filter;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.valor.vod.meta.model.database.dao.query.filter.SqlQueryBuilder;
import com.valor.vod.meta.model.database.dao.query.filter.alias.SqlOrderAlias;
import com.valor.vod.meta.model.database.dao.query.filter.alias.SqlQueryAlias;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlOrderBuilder {
    private static final Logger logger = LoggerFactory.getLogger(SqlQueryBuilder.class);
    private static String FIELD_SPLIT = ":";
    private static String ITEM_SPLIT = ";";
    private Map<String, String> orderByMap = Maps.newHashMap();
    private Map<String, String> orderByField = Maps.newHashMap();
    private String playlistOrder = "";
    private String searchOrder = "";
    private String orginStr = "";
    private SqlQueryAlias queryAlias;
    private int linked = 0;

    public SqlOrderBuilder(int linked, SqlQueryAlias queryAlias, String searchOrder, String playlistOrder) {
        this.playlistOrder = playlistOrder;
        this.searchOrder = searchOrder;
        this.queryAlias = queryAlias;
        this.orginStr = searchOrder + playlistOrder;
        this.linked = linked;
    }

    public String buildOrderSql() {
        this.orderByMap = Splitter.on((char)';').omitEmptyStrings().withKeyValueSeparator(":").split((CharSequence)this.orginStr);
        if (!this.orderByMap.isEmpty()) {
            this.orderByMap.forEach((k, v) -> {
                String field = SqlOrderAlias.getSortField(this.linked, k);
                if (Strings.isNullOrEmpty((String)field)) {
                    logger.info("Invalid sort arg.!!!{}:{}", k, v);
                } else {
                    this.orderByField.put(field, (String)v);
                }
            });
        }
        String sqlOrderWithAlias = "";
        String orderBy = Joiner.on((char)',').withKeyValueSeparator(" ").join(this.orderByField);
        sqlOrderWithAlias = !Strings.isNullOrEmpty((String)orderBy) ? Joiner.on((char)' ').skipNulls().join((Object)"order by", (Object)orderBy, new Object[0]) : (this.linked == 1 ? "order by #{tab_meta_link}.release_date_int desc" : "order by #{tab_meta}.release_date_int desc");
        return this.queryAlias.replaceAlias(sqlOrderWithAlias);
    }
}

