/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.meta.model.database.dao.query.filter;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.valor.vod.api.model.constant.EPlaylistType;
import com.valor.vod.api.model.filter.FilterHelper;
import com.valor.vod.common.tools.type.CollectionUtils;
import com.valor.vod.common.tools.type.DateTimeTools;
import com.valor.vod.meta.model.database.dao.query.filter.FilterField;
import com.valor.vod.meta.model.database.dao.query.filter.alias.MovieQueryAlias;
import com.valor.vod.meta.model.database.dao.query.filter.alias.SqlQueryAlias;
import com.valor.vod.meta.model.database.dao.query.filter.filter.FilterTools;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlQueryBuilder {
    private static final Logger logger = LoggerFactory.getLogger(SqlQueryBuilder.class);
    private static int FIELD_SIZE = 3;
    private static String FIELD_SPLIT = ":";
    private static String VALUE_SPLIT = ",";
    private static String ITEM_SPLIT = ";";
    private int filterLinked = 0;
    private int linked = 0;
    private long userId = 0L;
    private long pid = -1L;
    private long appVer = -1L;
    private boolean isIllegalLocation = false;
    private String filter = "";
    private String selectTable = "";
    private EPlaylistType plType;
    private String plTarget = "";
    private SqlQueryAlias queryAlias = null;
    private List<Long> cids;
    private StringBuilder fieldsCause = new StringBuilder("");
    private StringBuilder fromCause = new StringBuilder("");
    private StringBuilder joinCause = new StringBuilder("");
    private StringBuilder whereCause = new StringBuilder("");
    private Set<FilterField> filterFields = Sets.newHashSet();
    private Map<String, String> parameters = Maps.newHashMap();
    private Set<String> parameterKeySet = Sets.newHashSet();

    public SqlQueryBuilder(SqlQueryAlias queryAlias, Long uid, int linked, String filter, EPlaylistType plType, Long pid, Map<String, String> parameters, long appVer, boolean isIllegalLocation, List<Long> cids) {
        if (!CollectionUtils.isNullOrEmpty(parameters)) {
            this.parameters = parameters;
        }
        this.parameters = parameters;
        this.queryAlias = queryAlias;
        this.filter = filter;
        this.linked = linked;
        this.userId = uid;
        this.plType = plType;
        this.pid = pid;
        this.plTarget = this.parameters.getOrDefault("filter", "");
        this.appVer = appVer;
        this.isIllegalLocation = isIllegalLocation;
        if (!Strings.isNullOrEmpty((String)this.plTarget)) {
            this.filter = this.filter + this.plTarget;
        }
        this.selectTable = this.linked == 1 ? "#{tab_meta_link}" : "#{tab_meta}";
        this.cids = cids;
        this.generateFilterSql();
    }

    public static boolean isValidKey(String key) {
        return "genre".compareToIgnoreCase(key) == 0 || "country".compareToIgnoreCase(key) == 0 || "rating".compareToIgnoreCase(key) == 0 || "year".compareToIgnoreCase(key) == 0 || "reldate".compareToIgnoreCase(key) == 0;
    }

    public static String getSqlOperator(String opCode) {
        return FilterHelper.getSqlOperator((String)opCode);
    }

    private void parseFilterString() {
        if (this.filter == null) {
            return;
        }
        List metaStrs = Splitter.on((String)ITEM_SPLIT).omitEmptyStrings().trimResults().splitToList((CharSequence)this.filter);
        for (String item : metaStrs) {
            if (item.isEmpty()) {
                return;
            }
            List fields = Splitter.on((String)FIELD_SPLIT).omitEmptyStrings().trimResults().splitToList((CharSequence)item);
            if (fields.size() < 2) {
                logger.warn("Invalid filter item:{}", (Object)item);
                continue;
            }
            if (((String)fields.get(1)).isEmpty()) {
                logger.warn("value is empty filter key");
                continue;
            }
            FilterField filterField = new FilterField();
            filterField.setKey((String)fields.get(0));
            List values = Splitter.on((String)VALUE_SPLIT).omitEmptyStrings().trimResults().splitToList((CharSequence)fields.get(1));
            values.forEach(e -> filterField.addValue((String)e));
            if (fields.size() > 2) {
                filterField.setOperator(SqlQueryBuilder.getSqlOperator((String)fields.get(2)));
            } else {
                filterField.setOperator(" = ");
            }
            this.filterFields.add(filterField);
            if (!filterField.getKey().equalsIgnoreCase("linked")) continue;
            this.filterLinked = Integer.valueOf((String)filterField.getValues().toArray()[0]);
        }
    }

    private void generateFilterSql() {
        this.parseFilterString();
        this.appendFromCause(this.selectTable);
        this.whereCause.append(this.selectTable + ".type in ( #{tfv_media_type} )");
        this.whereCause.append(" and " + this.selectTable + ".adult=0");
        this.whereCause.append(" and " + this.selectTable + ".disable=0");
        if (this.plType == EPlaylistType.PLAYLIST) {
            this.appendFromCause(",vms_playlist_videos");
            if (this.whereCause.length() > 0) {
                this.whereCause.append(" and ");
            }
            this.whereCause.append(this.selectTable + ".id in (select video_id from vms_playlist_videos where playlist_id=");
            this.whereCause.append(this.pid);
            this.whereCause.append(")");
        }
        if (this.linked == 1) {
            this.whereCause.append(" and " + this.selectTable + ".id in( ");
            this.whereCause.append(SqlQueryAlias.getUserLinkedSql(this.cids));
            if ("3d".compareToIgnoreCase(this.parameters.getOrDefault("linkFormat", "")) == 0) {
                this.whereCause.append(" and format='3d'");
            }
            this.whereCause.append(")");
        }
        if (this.filterLinked == 0 && this.linked == 0 && "false".compareToIgnoreCase(this.parameters.getOrDefault("timeLimit", "")) != 0 && this.queryAlias instanceof MovieQueryAlias) {
            this.whereCause.append(" and(" + this.selectTable + ".release_date_int<=").append(DateTimeTools.distanceTodayByMonthInt((int)-2));
            this.whereCause.append(" or " + this.selectTable + ".linked!=0)");
        }
        this.filterFields.forEach(e -> {
            String filter = FilterTools.buildQueryFilter(e);
            if (!Strings.isNullOrEmpty((String)filter)) {
                if (this.whereCause.length() > 0) {
                    this.whereCause.append(" and ");
                }
                this.whereCause.append(filter);
            }
        });
    }

    public void addFilterField(String field) {
        if (this.fieldsCause.length() > 0) {
            this.fieldsCause.append(",");
        }
        this.fieldsCause.append(field);
    }

    public String buildQuerySql() {
        StringBuilder sb = new StringBuilder();
        sb.append("select ");
        sb.append((CharSequence)this.fieldsCause);
        sb.append(" from ");
        sb.append((CharSequence)this.fromCause);
        if (this.joinCause.length() > 0 || this.whereCause.length() > 0) {
            sb.append(" where ");
            sb.append((CharSequence)this.joinCause);
            if (this.joinCause.length() > 0) {
                sb.append(" and ");
            }
            sb.append((CharSequence)this.whereCause);
        }
        String sql = sb.toString();
        return this.queryAlias.replaceAlias(sql);
    }

    private void appendFromCause(String str) {
        this.fromCause.append(str);
    }
}

