/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.meta.model.service;

import com.google.common.collect.Maps;
import com.valor.vod.common.tools.type.CollectionUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public abstract class AbstractConfigService {
    protected Map<String, String> configMap = Maps.newHashMap();

    public void reload(Map<String, String> configs) {
        if (CollectionUtils.isNullOrEmpty(configs)) {
            this.configMap = configs;
        }
    }

    public String getValue(String key) {
        return this.configMap.get(key);
    }

    public String getValue(String key, String defaultValue) {
        return this.configMap.getOrDefault(key, defaultValue);
    }

    public List<String> getValueAsList(String key, String splitter) {
        String props = this.getValue(key, "");
        return Arrays.asList(props.split(splitter));
    }

    public boolean getBooleanValue(String key, boolean defaultValue) {
        String value = this.configMap.get(key);
        if (value != null) {
            return Boolean.parseBoolean(value.trim());
        }
        return defaultValue;
    }

    public int getIntValue(String key, int defaultValue) {
        String value = this.configMap.get(key);
        if (value != null) {
            try {
                return Integer.parseInt(value.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public long getLongValue(String key, long defaultValue) {
        String value = this.configMap.get(key);
        if (value != null) {
            try {
                return Long.parseLong(value.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public float getFloatValue(String key, float defaultValue) {
        String value = this.configMap.get(key);
        if (value != null) {
            try {
                return Float.parseFloat(value.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }
}

