package com.valor.vod.meta.model.database.constants.playlist;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author Tom Tang
 * @date 2021/8/31
 * @since 3.0.0
 */
public enum ESearchVideoListSubType2 {

    /**
     *
     */
    ALL,
    MOVIE,
    DOCUMENTARY,
    SERIES,
    SHORT,
    EXCEPT_FOR_MOVIE_AND_SERIES;

    private static final Map<String, ESearchVideoListSubType2> VALUE_MAP = Stream.of(values())
        .collect(Collectors.toMap(ESearchVideoListSubType2::name, Function.identity()));

    public static ESearchVideoListSubType2 of(String value) {
        if (value == null) {
            return ALL;
        }

        ESearchVideoListSubType2 searchListSubType = VALUE_MAP.get(value);
        return searchListSubType == null ? ALL : searchListSubType;
    }
}
