package com.valor.vod.meta.model.database.dao;

import com.google.common.base.Strings;
import com.google.common.collect.*;
import com.valor.vod.api.model.constant.EArtworkType;
import com.valor.vod.api.model.constant.EVideoType;
import com.valor.vod.api.model.tools.MediaTypeTools;
import com.valor.vod.common.tools.meta.LanguageTools;
import com.valor.vod.common.tools.type.CollectionUtils;
import com.valor.vod.common.tools.type.DateTimeTools;
import com.valor.vod.meta.model.database.ddo.identifier.Identifier;
import com.valor.vod.meta.model.database.ddo.index.MetaIndex;
import com.valor.vod.meta.model.database.ddo.index.PersonIndex;
import com.valor.vod.meta.model.database.ddo.linked.LinkedCacheDdo;
import com.valor.vod.meta.model.database.ddo.linked.LinkedCloudDdo;
import com.valor.vod.meta.model.database.ddo.media.Meta4Query;
import com.valor.vod.meta.model.database.ddo.media.MetaMetricTask;
import com.valor.vod.meta.model.database.ddo.media.base.AbstractArtwork;
import com.valor.vod.meta.model.database.ddo.media.tv.TVSeriesArtwork;
import com.valor.vod.meta.model.database.ddo.media.tv.TVTrakttvOnTheAirFromTrakt;
import com.valor.vod.meta.model.database.ddo.media.video.Video;
import com.valor.vod.meta.model.database.ddo.media.video.VideoArtwork;
import com.valor.vod.meta.model.database.dto.PersonDto;
import com.valor.vod.meta.model.database.dto.PersonDto4Merge;
import com.valor.vod.meta.model.database.dto.TVMetaDto4Merge;
import com.valor.vod.meta.model.database.dto.VideoMetaDto4Merge;
import com.valor.vod.meta.model.util.IdentifierUtil;
import common.base.tools.stat.StatTools;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.*;

/**
 * Created by Frank.Huang on 2016/4/23.
 */
@Repository
@Transactional(value = "metaTransactionManager")
public class MetaDao extends AbstractMetaBaseDao {
    private static final Logger logger = LoggerFactory.getLogger(MetaDao.class);

    @Autowired
    @Qualifier(value = "metaSessionFactory")
    protected SessionFactory metaSessionFactory;
//
//    @Autowired
//    protected CloudBaseDao cloudBaseDao;


    @Override
    @Transactional(value = "metaTransactionManager")
    public Session currentSession() {
        return metaSessionFactory.getCurrentSession();
    }

    @Override
    @Transactional(value = "metaTransactionManager")
    public void storeEntity(final Object entity) {
        super.storeEntity(entity);
    }

    @Override
    @Transactional(value = "metaTransactionManager")
    public void deleteEntity(final Object entity) {
        currentSession().delete(entity);
    }

    @Override
    @Transactional(value = "metaTransactionManager")
    public void storeAllIfAbsent(final Collection entities) {
        super.storeAllIfAbsent(entities);
    }

    @Override
    @Transactional(value = "metaTransactionManager")
    public void deleteAll(final Collection entities) {
        super.deleteAll(entities);
    }


    @Override
    @Transactional(value = "metaTransactionManager")
    public void storeAll(Collection entities) {
        super.storeAll(entities);
    }

    @Override
    @Transactional(value = "metaTransactionManager")
    public int executeUpdate(CharSequence queryCharSequence) {
        return super.executeUpdate(queryCharSequence);
    }

    @Override
    @Transactional(value = "metaTransactionManager")
    public int excuteSql(String sql) {
        return super.excuteSql(sql);
    }

    /**
     * 获取所有标示类型列表
     *
     * @return
     */
    public List<Identifier> getIdentifier() {
        return currentSession().createCriteria(Identifier.class).list();
    }

    /**
     * 获取索引id
     *
     * @param imdbId
     * @return
     */
    @Transactional(value = "metaTransactionManager", readOnly = true)
    public MetaIndex getMetaIndex(String imdbId) {
        return (MetaIndex) currentSession().createCriteria(MetaIndex.class)
            .add(Restrictions.eq("imdbId", imdbId))
            .uniqueResult();

    }


    @Transactional(value = "metaTransactionManager", readOnly = true)
    public PersonIndex getPersonIndex(String imdbId) {
        return (PersonIndex) currentSession().createCriteria(PersonIndex.class)
            .add(Restrictions.eq("imdbId", imdbId))
            .uniqueResult();
    }

    /**
     * 获取索引id
     *
     * @param ppId
     * @return
     */
    @Transactional(value = "metaTransactionManager", readOnly = true)
    public MetaIndex getMetaIndexByPpId(String ppId) {
        return (MetaIndex) currentSession().createCriteria(MetaIndex.class)
            .add(Restrictions.eq("ppId", ppId))
            .uniqueResult();

    }

    @Transactional(value = "metaTransactionManager", readOnly = true)
    public PersonIndex getPersonIndexByPcId(String pcId) {
        return (PersonIndex) currentSession().createCriteria(PersonIndex.class)
            .add(Restrictions.eq("pcId", pcId))
            .uniqueResult();
    }

    @Transactional(value = "metaTransactionManager", readOnly = true)
    public Map<String, MetaIndex> getMetaIndexByPpIds(Set<String> ppIds) {
        Map<String, MetaIndex> indexMap = Maps.newHashMap();
        if (ppIds.isEmpty()) {
            return indexMap;
        }

        try {
            StatTools.startDBTimer("getMetaIndexByPpId");
            List<MetaIndex> ids = currentSession().createCriteria(MetaIndex.class)
                .add(Restrictions.in("ppId", ppIds))
                .list();

            ids.forEach(e -> {
                indexMap.put(e.getPpId().toLowerCase(), e);
            });

            return indexMap;
        } finally {
            StatTools.stopDBTimer("getMetaIndexByImdbId");
        }
    }

    @Override
    @Transactional(value = "metaTransactionManager")
    public List getListData(boolean enableCahce, Class returnType, Map<String, Object> filters) {
        StatTools.startDBTimer(returnType.getSimpleName());
        try {
            return super.getListData(enableCahce, returnType, filters);
        } finally {
            StatTools.stopDBTimer(returnType.getSimpleName());
        }
    }

    @Override
    @Transactional(value = "metaTransactionManager")
    public Object getData(boolean enableCahce, Class returnType, Map<String, Object> filters) {
        StatTools.startDBTimer(returnType.getSimpleName());
        try {
            return super.getData(enableCahce, returnType, filters);
        } finally {
            StatTools.stopDBTimer(returnType.getSimpleName());
        }
    }

    @Override
    @Transactional(value = "metaTransactionManager")
    public List getListDataIn(boolean enableCahce, Class returnType, Map<String, Object> filters) {
        try {
            StatTools.startDBTimer(returnType.getSimpleName());
            return super.getListDataIn(enableCahce, returnType, filters);
        } finally {
            StatTools.stopDBTimer(returnType.getSimpleName());
        }
    }

    @Override
    @Transactional(value = "metaTransactionManager")
    public Set getSetData(boolean enableCahce, Class returnType, Map<String, Object> filters) {
        Set set = new HashSet<>(getListData(enableCahce, returnType, filters));
        return set;
    }


    @Transactional(value = "metaTransactionManager")
    public void storePerson(PersonDto personDto) {
        if (personDto.isValid()) {
            storeEntity(personDto.getPerson());
//            storeEntity(personDto.getLocale());
            storeAllIfAbsent(personDto.getMlLocales());
            storeAllIfAbsent(personDto.getKnowFors());
            storeAllIfAbsent(personDto.getAwards());
            storeAllIfAbsent(personDto.getFilmographies());
        }
    }

    @Transactional(value = "metaTransactionManager")
    public void savePerson(PersonDto4Merge personDto4Merge) {
        if (personDto4Merge.isValid()) {

            Set delSet = personDto4Merge.getToBeDelSet();
            if (!CollectionUtils.isNullOrEmpty(delSet)) {
                deleteAll(delSet);
            }

            storeEntity(personDto4Merge.getPerson());
            storeEntity(personDto4Merge.getLocale());
            storeAllIfAbsent(personDto4Merge.getMlLocales());

            storeAllIfAbsent(personDto4Merge.getKnowFors());
            storeAllIfAbsent(personDto4Merge.getAwards());
            storeAllIfAbsent(personDto4Merge.getFilmographies());
            storeAllIfAbsent(personDto4Merge.getEsAward());
            storeAllIfAbsent(personDto4Merge.getPtAward());
            storeAllIfAbsent(personDto4Merge.getPersonTags());

            logger.info("[PERSON]{}", personDto4Merge.dumpSyncStat(personDto4Merge.getPerson().getId()
                , personDto4Merge.getPerson().getImdbId(), EVideoType.PERSON));
        }
    }

    @Transactional(value = "metaTransactionManager")
    public void storeVideoMeta(VideoMetaDto4Merge meta) {

        Set delSet = meta.getToBeDelSet();
        if (!CollectionUtils.isNullOrEmpty(delSet)) {
            deleteAll(delSet);
        }

        storeEntity(meta.getVideo());
        storeEntity(meta.getMeta4Query());
//        storeEntity(meta.getVideoLocale());
        storeAllIfAbsent(meta.getVideoLocales());

        storeAllIfAbsent(meta.getTrailers());
        storeAllIfAbsent(meta.getArtworks());
        storeAllIfAbsent(meta.getSynopsises());
        storeAllIfAbsent(meta.getUserReviews());
        storeAllIfAbsent(meta.getGenres());
        storeAllIfAbsent(meta.getCountries());
        storeAllIfAbsent(meta.getCerts());
        storeAllIfAbsent(meta.getReleaseInfos());
        storeAllIfAbsent(meta.getCasts());
        storeAllIfAbsent(meta.getFilmographies());
        storeAllIfAbsent(meta.getSimilars());
        storeAllIfAbsent(meta.getTitleAkas());
        storeAllIfAbsent(meta.getParentsGuides());
        storeAllIfAbsent(meta.getAwards());
        storeAllIfAbsent(meta.getCompanies());
        meta.getPersons().forEach(e -> {
            storePerson(e);
        });

        if (meta.getVideo() != null) {
            logger.info("[META][VIDEO]{}", meta.dumpSyncStat(meta.getVideo().getId(), meta.getVideo().getMetaId(), meta.getVideo().getType()));
        }
    }


    public void deleteTVMeta(TVMetaDto4Merge meta) {
//        Set delSet = meta.getToBeDelSet();
//        if (!CollectionUtils.isNullOrEmpty(delSet)){
//            deleteAll(delSet);
//        }
    }

    //    @Transactional (value = "metaTransactionManager")
    public void updateTVMeta(TVMetaDto4Merge meta) {
        Set delSet = meta.getToBeDelSet();
        if (!CollectionUtils.isNullOrEmpty(delSet)) {
            deleteAll(delSet);
        }
        storeEntity(meta.getSeries());
        storeEntity(meta.getMeta4Query());
//        storeEntity(meta.getSeriesLocale());
        storeAllIfAbsent(meta.getSeriesLocals());
        storeAllIfAbsent(meta.getTrailers());
        storeAllIfAbsent(meta.getArtworks());
        storeAllIfAbsent(meta.getSynopsises());
        storeAllIfAbsent(meta.getUserReviews());
        storeAllIfAbsent(meta.getGenres());
        storeAllIfAbsent(meta.getCountries());
        storeAllIfAbsent(meta.getCerts());
        storeAllIfAbsent(meta.getFilmographies());
        storeAllIfAbsent(meta.getReleaseInfos());
        storeAllIfAbsent(meta.getCasts());
        storeAllIfAbsent(meta.getSimilars());
        storeAllIfAbsent(meta.getTitleAkas());
        storeAllIfAbsent(meta.getAwards());
        storeAllIfAbsent(meta.getCompanies());
        storeAllIfAbsent(meta.getParentsGuides());
        storeAllIfAbsent(meta.getSeasons());
        storeAllIfAbsent(meta.getEpisodes());

        logger.info("[META][SERIES]{}", meta.dumpSyncStat(meta.getSeries()));
    }

    public void updateTV(TVMetaDto4Merge meta) {
        deleteTVMeta(meta);
        updateTVMeta(meta);
    }


    public Map<String, MetaIndex> getMetaIndexByMetaId(Set<String> metaIds) {
        Map<String, MetaIndex> indexMap = Maps.newHashMap();
        if (metaIds.isEmpty()) {
            return indexMap;
        }

        Set<String> imdbIds = Sets.newHashSet();
        Set<Long> vmsIds = Sets.newHashSet();
        metaIds.forEach(e -> {
            if (!Strings.isNullOrEmpty(e)) {
                if (e.startsWith("mm")) {
                    vmsIds.add(IdentifierUtil.getInternalId(e));
                } else {
                    imdbIds.add(e);
                }
            }
        });

        if (!CollectionUtils.isNullOrEmpty(imdbIds)) {
            indexMap = getMetaIndexByImdbId(imdbIds);
        }

        if (!CollectionUtils.isNullOrEmpty(vmsIds)) {
            Map<Long, MetaIndex> vmsIndexs = getMetaIndexByVmsId(vmsIds);
            if (!CollectionUtils.isNullOrEmpty(vmsIndexs)) {

                for (Map.Entry<Long, MetaIndex> entity : vmsIndexs.entrySet()) {
                    indexMap.put(IdentifierUtil.getDisplayId(entity.getKey()), entity.getValue());
                }
            }
        }

        return indexMap;
    }

    public Map<String, MetaIndex> getMetaIndexByImdbId(Set<String> imdbIds) {
        Map<String, MetaIndex> indexMap = Maps.newHashMap();
        if (imdbIds.isEmpty()) {
            return indexMap;
        }

        try {
            StatTools.startDBTimer("getMetaIndexByImdbId");
            List<MetaIndex> ids = currentSession().createCriteria(MetaIndex.class)
                .add(Restrictions.in("imdbId", imdbIds))
                .list();

            ids.forEach(e -> {
                indexMap.put(e.getImdbId(), e);
            });

            return indexMap;
        } finally {
            StatTools.stopDBTimer("getMetaIndexByImdbId");
        }
    }

    public Map<Long, MetaIndex> getMetaIndexByVmsId(Set<Long> ids) {
        Map<Long, MetaIndex> indexMap = Maps.newHashMap();
        if (ids.isEmpty()) {
            return indexMap;
        }

        try {
            StatTools.startDBTimer("getMetaIndexByVmsId");
            List<MetaIndex> idIndexs = currentSession().createCriteria(MetaIndex.class)
                .add(Restrictions.in("vmsId", ids))
                .list();

            idIndexs.forEach(e -> {
                indexMap.put(e.getVmsId(), e);
            });

            return indexMap;
        } finally {
            StatTools.stopDBTimer("getMetaIndexByVmsId");
        }
    }

    public Map<String, Long> getVmsIdsByPpId(Set<String> ppIds) {
        Map<String, Long> localIds = Maps.newHashMap();
        if (ppIds.isEmpty()) {
            return localIds;
        }
        List<MetaIndex> ids = currentSession().createCriteria(MetaIndex.class)
            .setCacheable(true)
            .setReadOnly(true)
            .add(Restrictions.in("ppId", ppIds))
            .list();

        ids.forEach(e -> {
            localIds.put(e.getPpId(), e.getVmsId());
        });

        return localIds;
    }

    public Map<String, Long> getVmsIdsByImdbId(Set<String> imdbIds) {
        Map<String, Long> localIds = Maps.newHashMap();
        if (imdbIds.isEmpty()) {
            return localIds;
        }
        List<MetaIndex> ids = currentSession().createCriteria(MetaIndex.class)
            .setCacheable(true)
            .setReadOnly(true)
            .add(Restrictions.in("imdbId", imdbIds))
            .list();

        ids.forEach(e -> {
            localIds.put(e.getImdbId(), e.getVmsId());
        });

        return localIds;
    }

    public Map<String, Long> getPersonIdByImdbId(Set<String> imdbIds) {
        Map<String, Long> localIds = Maps.newHashMap();
        if (CollectionUtils.isNullOrEmpty(imdbIds)) {
            return localIds;
        }

        List<PersonIndex> ids = currentSession().createCriteria(PersonIndex.class)
            .setCacheable(true)
            .setReadOnly(true)
            .add(Restrictions.in("imdbId", imdbIds))
            .list();

        ids.forEach(e -> {
            localIds.put(e.getImdbId(), e.getVmsId());
        });

        return localIds;
    }

    public Map<String, PersonIndex> getPersonIndexByImdbId(Set<String> imdbIds) {
        Map<String, PersonIndex> localIds = Maps.newHashMap();
        if (CollectionUtils.isNullOrEmpty(imdbIds)) {
            return localIds;
        }

        List<PersonIndex> ids = currentSession().createCriteria(PersonIndex.class)
            .setCacheable(true)
            .setReadOnly(true)
            .add(Restrictions.in("imdbId", imdbIds))
            .list();

        ids.forEach(e -> {
            localIds.put(e.getImdbId(), e);
        });

        return localIds;
    }

    public Map<String, PersonIndex> getPersonIndexByPcIdSet(Set<String> pcIds) {
        Map<String, PersonIndex> localMap = Maps.newHashMap();
        if (CollectionUtils.isNullOrEmpty(pcIds)) {
            return localMap;
        }

        List<PersonIndex> ids = currentSession().createCriteria(PersonIndex.class)
            .setCacheable(true)
            .setReadOnly(true)
            .add(Restrictions.in("pcId", pcIds))
            .list();

        ids.forEach(e -> {
            localMap.put(e.getPcId(), e);
        });
        return localMap;
    }

    public int getPopCount(Long vmsId) {
        String sql = String.format("select COUNT(*) from vms_meta_event_log where vms_id = %s", vmsId);
        return ((BigInteger) this.currentSession().createSQLQuery(sql).uniqueResult()).intValue();
    }

    public int getRatingCount(Long vmsId) {
        String sql = String.format("select COUNT(*) from vms_user_rating where vms_id = %s", vmsId);
        return ((BigInteger) this.currentSession().createSQLQuery(sql).uniqueResult()).intValue();
    }

    public float getRatingAvg(Long vmsId) {
        String sql = String.format("select AVG(rating) from vms_user_rating where vms_id = %s", vmsId);
        Object result = this.currentSession().createSQLQuery(sql).uniqueResult();
        return (result != null) ? ((BigDecimal) result).floatValue() : 0.0f;
    }

    public Set difference(Set set1, Set set2) {
        return Sets.difference(set1, set2);
    }

    public void deleteByImdbId(String imdbId) {
        logger.info("Delete data:{}", imdbId);
        MetaIndex index = (MetaIndex) getData(false, MetaIndex.class, ImmutableMap.of("imdbId", imdbId));
        if (index != null) {
            excuteSql("delete from vms_video where id=" + index.getVmsId());
            excuteSql("delete from vms_video_locale where id=" + index.getVmsId());
            excuteSql("delete from vms_video_artwork where id=" + index.getVmsId());
            excuteSql("delete from vms_video_awards where id=" + index.getVmsId());
            excuteSql("delete from vms_video_certification where id=" + index.getVmsId());
            excuteSql("delete from vms_video_country where id=" + index.getVmsId());
            excuteSql("delete from vms_video_genre where id=" + index.getVmsId());
            excuteSql("delete from vms_video_release_info where id=" + index.getVmsId());
            excuteSql("delete from vms_video_similar where id=" + index.getVmsId());
            excuteSql("delete from vms_video_synopsis where id=" + index.getVmsId());
            excuteSql("delete from vms_video_trailer where id=" + index.getVmsId());
            excuteSql("delete from vms_video_userreview where id=" + index.getVmsId());
            excuteSql("delete from vms_video_castcrew where media_id=" + index.getVmsId());
            excuteSql("delete from meta_index where vms_id=" + index.getVmsId());
        }
    }


    @Override
    public long criteriaQueryCount(Class valueType) {
        return super.criteriaQueryCount(valueType);
    }

    public void deletePersonInfo(long id) {
        int ret1 = excuteSql("delete from vms_person_filmography where person_id=" + id);
        int ret2 = excuteSql("delete from vms_person_knownfor where person_id=" + id);
        int ret3 = excuteSql("delete from vms_person_award where id=" + id);
        logger.info("Delete person[{}] info filmography [{}] knownfor[{}]  award[{}]", id, ret1, ret2, ret3);
    }

//    public List<Long> queryMetaIdsByPlayList(PlaylistDDO playlist,SqlQueryAlias queryAlias,int first,int max,boolean isIllegalLocation){
//        SqlScalars sqlScalars = new SqlScalars();
//        Map<String,String> mapFilter =Maps.newHashMap();
//        if (!Strings.isNullOrEmpty(playlist.getTarget())){
//            mapFilter = Splitter.on("&").withKeyValueSeparator("=").split(playlist.getTarget());
//        }
//
//        SqlQueryBuilder sqlBuilder = new SqlQueryBuilder(queryAlias, -1L, 0, "", playlist.getType(), playlist.getId(), mapFilter, 99999, isIllegalLocation,getUserCloudCids(a, , , ));
//
//        sqlBuilder.addFilterField(queryAlias.distinctField(0,"id"));
//        sqlScalars.addToSql(sqlBuilder.buildQuerySql());
//
//        SqlOrderBuilder orderByHelper = new SqlOrderBuilder(0, queryAlias,
//                "",mapFilter.getOrDefault("sort",""));
//
//        sqlScalars.addToSql(orderByHelper.buildOrderSql());
//
//        sqlScalars.addScalar("id", LongType.INSTANCE);
//        List<Long> ids = query(Long.class, sqlScalars, first, max);
//        return ids;
//    }

    @Override
    public String getLatestUpdateTime(Class clazz, Map<String, Object> filters) {
        return super.getLatestUpdateTime(clazz, filters);
    }

    @Override
    public Date getLatestUpdateDate(Class clazz, Map<String, Object> filters) {
        return super.getLatestUpdateDate(clazz, filters);
    }

    public List<LinkedCloudDdo> queryLinkedFile(Set<Long> ids) {
        return getListDataIn(false, LinkedCloudDdo.class, ImmutableMap.of("videoId", ids));
    }

    public Map<Long, Integer> queryLinkedStatus(Set<Long> ids) {
        Map<Long, Integer> linkedMap = Maps.newHashMap();
        if (CollectionUtils.isNullOrEmpty(ids)) {
            return linkedMap;
        }
        List<LinkedCloudDdo> linkedClouds = queryLinkedFile(ids);
        if (CollectionUtils.isNullOrEmpty(linkedClouds)) {
            return linkedMap;
        }

        linkedClouds.forEach(e -> {
            linkedMap.put(e.getVideoId(), 1);
        });

        return linkedMap;

    }


//    public int getMovieInTheater(long appVer,
//                                 Long uid,
//                                 long accountId,
//                                 int accountType,
//                                 int linked,
//                                 String region,
//                                 boolean isIllegalLocation,
//                                 int first,
//                                 int max,
//                                 Map<Long,MovieInTheater> itmMap){
//        Criteria criteria = currentSession().createCriteria(MovieInTheater.class)
//                .setCacheable(true)
//                .add(Restrictions.eq("region",region))
//                .addOrder(Order.asc("status"))
//                .addOrder(Order.desc("localeReleaseDateInt"));
//
//        if (linked==1) {
//            criteria.setCacheable(false);
//            criteria.add(Restrictions.sqlRestriction("{alias}.id in ("+ SqlQueryAlias.getUserLinkedSql(getUserCloudCids(uid, accountId ,accountType,isIllegalLocation)) + ")"));
//        }
//
//        criteria.setProjection(Projections.rowCount());
//        long total = (long) criteria.uniqueResult();
//
//
//        if (itmMap == null){
//            itmMap = Maps.newHashMap();
//        }
//
//        if (total == 0){
//            return 0;
//        }
//
//        criteria.setProjection(null);
//        criteria.setFirstResult(first);
//        criteria.setMaxResults(max);
//        List<MovieInTheater> inTheaterList = criteria.list();
//
//        if (linked == 0){
//            Set<Long> linkedStatusIds = Sets.newHashSet();
//            inTheaterList.forEach(e->{
//                linkedStatusIds.add(e.getId());
//            });
//            Map<Long,Integer> linkedStatusMap = queryLinkedStatus(linkedStatusIds);
//
//            inTheaterList.forEach(e->{
//                e.setLinked(linkedStatusMap.getOrDefault(e.getId(),0));
//            });
//        }
//
//        if (!CollectionUtils.isNullOrEmpty(inTheaterList)) {
//            for (MovieInTheater e : inTheaterList) {
//                itmMap.put(e.getId(), e);
//            }
//        }
//
//        return Long.valueOf(total).intValue();
//    }

    public List<MetaMetricTask> getMetaMetricTasks(int first,
                                                   int max) {
        Criteria criteria = currentSession().createCriteria(MetaMetricTask.class)
            .setCacheable(true)
            .addOrder(Order.asc("lastModifyTime"));
        criteria.setProjection(null);
        criteria.setFirstResult(first);
        criteria.setMaxResults(max);
        List<MetaMetricTask> taskList = criteria.list();
        return taskList;
    }

    public String getMaxOnAirTodayDate() {
        Criteria criteria = currentSession().createCriteria(TVTrakttvOnTheAirFromTrakt.class);
        criteria.setReadOnly(true);
        criteria.add(Restrictions.le("lastAirDate", DateTimeTools.currentDateStr2()));

        criteria.setProjection(Projections.projectionList().add(Projections.max("lastAirDate")));
        return (String) criteria.uniqueResult();
    }

//    public int queryOnTheAir(long appVer,
//                             Long uid,
//                             long accountId,
//                             int accountType,
//                             int linked,
//                             boolean isToday,
//                             boolean isIllegalLocation,
//                             int first,
//                             int max,
//                             Set<Long> idList){
//        Criteria criteria = currentSession().createCriteria(TVTrakttvOnTheAirFromTrakt.class);
//        criteria.setCacheable(true);
//        criteria.setFirstResult(first);
//        criteria.setMaxResults(max);
//
//        if (isToday){
//            String lastAiredDate = Strings.nullToEmpty(getMaxOnAirTodayDate());
//            logger.info("Use lastAirDate[{}] for TV On Air Today",lastAiredDate);
//            criteria.add(Restrictions.eq("lastAirDate", lastAiredDate));
//        }else {
//            criteria.add(Restrictions.gt("lastAirDate", DateTimeTools.currentDateStr2()));
//        }
//
//        if (linked == 1){
//            criteria.add(Restrictions.sqlRestriction("{alias}.id in("+SqlQueryAlias.getUserLinkedSql(getUserCloudCids(uid, accountId ,accountType,isIllegalLocation ))+")"));
//        }
//
//        criteria.addOrder(Order.asc("lastAirDateInt"));
//        criteria.addOrder(Order.asc("lastAirDate"));
//        List<TVTrakttvOnTheAirFromTrakt> onTheAirs =  criteria.list();
//
//        Long count = (Long) criteria.setProjection(Projections.rowCount())
//                .setFirstResult(0)
//                .setMaxResults(Integer.MAX_VALUE)
//                .uniqueResult();
//
//
//        onTheAirs.forEach(e->{
//            idList.add(e.getId());
//        });
//
//        return count.intValue();
//    }

    public List<LinkedCacheDdo> queryLinkedCache(Date date) {
        Criteria criteria = currentSession().createCriteria(LinkedCacheDdo.class);
        criteria.setReadOnly(true);
        if (date != null) {
            criteria.add(Restrictions.gt("lastModifyTime", date));
        }

        return criteria.list();
    }

    public int updateLinkedTime(long id, long linkedTime) {
        StringBuffer sb = new StringBuffer();
        sb.append("update vms_meta_for_query");
        sb.append(" set linked=1,linked_time=").append(linkedTime);
        sb.append(" where id=").append(id);

//        logger.info("Run sql:[{}]", sb.toString());
        int effectCount = executeSqlUpdate(sb);
        logger.info("update [{}] linked time to [{}], effectCount:[{}]", id, linkedTime, effectCount);

        return effectCount;
    }

    public Meta4Query getMeta4Query(long id, EVideoType type) {
        return (Meta4Query) currentSession().createCriteria(Meta4Query.class)
            .add(Restrictions.eq("id", id))
            .add(Restrictions.eq("type", type))
            .uniqueResult();
    }


    public boolean isReduceWeight(long id, EVideoType type) {
        Meta4Query meta4Query = getMeta4Query(id, type);
        return isReduceWeight(meta4Query);
    }

    public boolean isReduceWeight(Meta4Query meta4Query) {
        if (meta4Query == null) {
            return true;
        }

        if (meta4Query.getRating() <= 0) {
            return true;
        }

        if (meta4Query.getHasArtwork() == 0 || meta4Query.getHasArtwork() == 2) {
            return true;
        }

        return false;
    }

//    public PlaylistDDO getPlaylistById(Long id){
//        return  (PlaylistDDO)currentSession().byId(PlaylistDDO.class).load(id);
//    }

    public Map<EArtworkType, String> getFirstExistArtwork(Class clazz, Set<Long> ids, String language) {
        for (Long id : ids) {
            Map<EArtworkType, String> map = getArtworks(clazz, id, language);
            if (!CollectionUtils.isNullOrEmpty(map)) {
                return map;
            }
        }

        return Maps.newHashMap();
    }

    public Map<EArtworkType, String> getArtworks(Class clazz, long id, String language) {
        List artworks = currentSession().createCriteria(clazz)
            .setCacheable(true).setReadOnly(true)
            .add(Restrictions.eq("id", id))
            .add(Restrictions.eq("language", language))
            .add(Restrictions.eq("master", 1))
            .add(Restrictions.ne("url", ""))
            .list();


        if (CollectionUtils.isNullOrEmpty(artworks)) {
            return null;
        }

        Map<EArtworkType, String> map = Maps.newHashMap();

        artworks.forEach(e -> {
            AbstractArtwork artwork = (AbstractArtwork) e;
            if (!Strings.isNullOrEmpty(artwork.getUrl().trim())) {
                map.put(artwork.getArtworkType(), artwork.getUrl());
            }
        });

        if (map.get(EArtworkType.POSTER) == null) {
            return null;
        }

        return map;
    }

    public Map<String, Video> queryVideosByImdbId(Set<String> ids) {
        Map<String, Video> videoMap = Maps.newHashMap();

        List<Video> videos = getListDataIn(false, Video.class, ImmutableMap.of("imdbId", ids));
        if (CollectionUtils.isNullOrEmpty(videos)) {
            return videoMap;
        }

        videos.forEach(e -> {
            videoMap.put(e.getImdbId(), e);
        });

        return videoMap;
    }

    public Map<String, Video> queryVideosByPpId(Set<String> ids) {
        Map<String, Video> videoMap = Maps.newHashMap();

        List<Video> videos = getListDataIn(false, Video.class, ImmutableMap.of("ppId", ids));
        if (CollectionUtils.isNullOrEmpty(videos)) {
            return videoMap;
        }

        videos.forEach(e -> {
            videoMap.put(e.getPpId(), e);
        });

        return videoMap;
    }

    public List<AbstractArtwork> queryArtworks(EVideoType mediaType,
                                               Set<Long> ids,
                                               String language,
                                               boolean isMaster,
                                               boolean enableCache) {
        return queryArtworks(mediaType, ids, language, isMaster, enableCache, -1);
    }

    public List<AbstractArtwork> queryArtworks(EVideoType mediaType,
                                               Set<Long> ids,
                                               String language,
                                               boolean isMaster,
                                               boolean enableCache,
                                               int maxResult) {
        Class clazz = null;
        if (MediaTypeTools.isSeries(mediaType)) {
            clazz = TVSeriesArtwork.class;
        } else {
            clazz = VideoArtwork.class;
        }

        List<AbstractArtwork> artworks = Lists.newArrayList();
        if (CollectionUtils.isNullOrEmpty(ids)) {
            return Lists.newArrayList();
        }

        Criteria criteria = currentSession().createCriteria(clazz);
        criteria.setReadOnly(true);
        criteria.setCacheable(enableCache);
        criteria.add(Restrictions.in("id", ids));
        criteria.add(Restrictions.in("language", ImmutableSet.of(LanguageTools.getOrDefaultLanguage(language), LanguageTools.LANG_EN)));
        if (isMaster) {
            criteria.add(Restrictions.eq("master", 1));
        }

        if (maxResult > 0) {
            criteria.setFirstResult(0);
            criteria.setMaxResults(maxResult);
        }

        return criteria.list();
    }


    public Map<Long, Meta4Query> getMeta4Query(Set<Long> ids) {
        if (CollectionUtils.isNullOrEmpty(ids)) {
            return Maps.newHashMap();
        }

        try {
            StatTools.startDBTimer("getMeta4Query");
            List<Meta4Query> meta4QueryList = currentSession().createCriteria(Meta4Query.class)
                .add(Restrictions.in("id", ids)).list();

            Map<Long, Meta4Query> meta4QueryMap = Maps.newHashMap();
            meta4QueryList.forEach(e -> {
                meta4QueryMap.put(e.getId(), e);
            });

            return meta4QueryMap;
        } finally {
            StatTools.stopDBTimer("getMeta4Query");
        }
    }

}

