package com.valor.vod.meta.model.database.dao;

import com.google.common.collect.ImmutableMap;
import com.valor.vod.meta.model.database.ddo.playlist.PlaylistNodeDDO;
import com.valor.vod.meta.model.database.ddo.playlist.PlaylistNodeVersionDDO;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigInteger;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author Bruce Wu
 * @since 2022-10-08
 */
@Repository
@Transactional(value = "metaTransactionManager")
@SuppressWarnings("all")
public class PlaylistVersionDao extends AbstractMetaBaseDao {

    /**
     * 查询最近一条生效的版本号
     *
     * @param playlistNodeId
     * @return
     */
    public PlaylistNodeVersionDDO getLatestValid(Long playlistNodeId) {
        NativeQuery<PlaylistNodeVersionDDO> query =
                currentSession()
                        .createNativeQuery(
                                "select * from playlist_node_version where playlist_node_id =:playlistNodeId and status = 1 order by version desc limit 1",
                                PlaylistNodeVersionDDO.class);
        query.setParameter("playlistNodeId", playlistNodeId);
        return query.uniqueResult();
    }

    public List<PlaylistNodeVersionDDO> getList(Long playlistNodeId) {
        List<PlaylistNodeVersionDDO> list =
                getListDataIn(
                        false,
                        PlaylistNodeVersionDDO.class,
                        ImmutableMap.of("playlistNodeId", playlistNodeId));
        list.sort((o1, o2) -> (int) (o2.getVersion() - o1.getVersion()));
        return list;
    }

    /**
     * 获取父节点
     *
     * @param playlistId
     * @return
     */
    public List<PlaylistNodeDDO> getParentNodes(long playlistId) {
        NativeQuery<PlaylistNodeDDO> query =
                currentSession()
                        .createNativeQuery(
                                "select * from playlist_node where vms_id =:vmsId",
                                PlaylistNodeDDO.class);
        query.setParameter("vmsId", playlistId);
        return query.list();
    }

    /**
     * @param nodeIdList
     * @return
     */
    public List<Long> getTreeRootNodeIds(List<Long> nodeIdList) {
        Session session = currentSession();
        NativeQuery query =
                session.createNativeQuery(
                        "select distinct root_node_id from portal_product where root_node_id in :nodeIdList");

        query.setParameterList("nodeIdList", nodeIdList);
        List<Object> list = query.list();
        return list.stream()
                .filter(e -> Objects.nonNull(e))
                .map(e -> Long.valueOf(e.toString()))
                .collect(Collectors.toList());
    }
}
