package com.valor.vod.meta.model.database.ddo.cloud;

import com.valor.vod.api.model.cloud.ECloudFileStatus;
import com.valor.vod.api.model.cloud.ECloudSite;
import com.valor.vod.common.database.model.AbstractLMI;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

import javax.persistence.*;

/**
 * Created by Frank.Huang on 2016/10/18.
 */
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
@Entity
@Table(name = "cloud_file")
public class CloudFileDdo extends AbstractLMI {
    @Id
    @Column(name = "cid")
    public Long cid = -1L;

    @Id
    @Column(name = "res_id", length = 128)
    public String resId = "";

    @Column(name = "res_path", length = 1024)
    private String resPath = "";

    @Column(name = "res_handle", length = 2048)
    private String resHandle = "";     //解码key

    @Column(name = "decode_key", length = 1024)
    private String decodeKey = "";     //解码key

    @Column(name = "parent_id", length = 1024)
    private String parentId = "";      //folderId

    @Column(name = "size")
    private long size;            //文件长度

    @Column(name = "checksum", length = 128)
    private String checksum = "";      //内容数据签名checksum

    @Column(name = "create_ts")
    private long createTimestamp; //创建时间

    @Column(name = "update_ts")
    private long modifyTimestamp; //修改时间

    @Column(name = "name", length = 256)
    private String name = "";

    @Column(name = "mime_type", length = 256)
    private String mimeType = "";

    @Column(name = "fetch_time")
    private long fetchTime;

    @Column(name = "status")
    private ECloudFileStatus status;

    @Transient
    @Deprecated
    @Enumerated(value = EnumType.STRING)
    @Column(name = "site", length = 128)
    private ECloudSite site;

    @Transient
    @Deprecated
    @Column(name = "acct_alias", length = 128)
    private String acct = "";

    @Column(name = "shared")
    private int shared;

    //比如 tt号码
    @Column(name = "meta_id", length = 64)
    private String metaId = "";

    @Column(name = "season")
    private int season = 1;

    @Column(name = "episode")
    private int episode = 1;

    @Column(name = "format", length = 512)
    private String format = "";   //格式 3D/VR etc.

    @Column(name = "quality", length = 512)
    private String quality = "";  ////质量 320p/480p/720p/1080p/4k

    @Column(name = "extra", length = 512)
    private String extra = "";//附加信息, 例如 特别版本，献礼版本等

    @Column(name = "audio_languege", columnDefinition = "bigint default -1L")
    private Long audioLanguege = -1L; //音频语言，long值

    @Column(name = "multi_episode", length = 512)
    private String multiEpisode = "";//多episode

    @Column(name = "resolution_type")
    private int resolutionType = 0;//0:默认 1:未解析到 2:newCloudName

    @Column(name = "resolution", length = 512)
    private String resolution = "";

    public Long getCid() {
        return cid;
    }

    public void setCid(Long cid) {
        this.cid = cid;
    }

    public ECloudSite getSite() {
        return site;
    }

    public void setSite(ECloudSite site) {
        this.site = site;
    }

    public String getAcct() {
        return acct;
    }

    public void setAcct(String acct) {
        this.acct = acct;
    }

    public String getResId() {
        return resId;
    }

    public void setResId(String resId) {
        this.resId = resId;
    }

    public String getResPath() {
        return resPath;
    }

    public void setResPath(String resPath) {
        this.resPath = resPath;
    }

    public String getDecodeKey() {
        return decodeKey;
    }

    public void setDecodeKey(String decodeKey) {
        this.decodeKey = decodeKey;
    }

    public String getParentId() {
        return parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public long getSize() {
        return size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String getChecksum() {
        return checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public long getCreateTimestamp() {
        return createTimestamp;
    }

    public void setCreateTimestamp(long createTimestamp) {
        this.createTimestamp = createTimestamp;
    }

    public long getModifyTimestamp() {
        return modifyTimestamp;
    }

    public void setModifyTimestamp(long modifyTimestamp) {
        this.modifyTimestamp = modifyTimestamp;
    }

    public ECloudFileStatus getStatus() {
        return status;
    }

    public void setStatus(ECloudFileStatus status) {
        this.status = status;
    }

    public String getMetaId() {
        return metaId;
    }

    public void setMetaId(String metaId) {
        this.metaId = metaId;
    }

    public int getSeason() {
        return season;
    }

    public void setSeason(int season) {
        this.season = season;
    }

    public int getEpisode() {
        return episode;
    }

    public void setEpisode(int episode) {
        this.episode = episode;
    }

    public String getFormat() {
        return format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getQuality() {
        return quality;
    }

    public void setQuality(String quality) {
        this.quality = quality;
    }

    public String getExtra() {
        return extra;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }

    public int getShared() {
        return shared;
    }

    public void setShared(int shared) {
        this.shared = shared;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMimeType() {
        return mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public long getFetchTime() {
        return fetchTime;
    }

    public void setFetchTime(long fetchTime) {
        this.fetchTime = fetchTime;
    }

    public String getResHandle() {
        return resHandle;
    }

    public void setResHandle(String resHandle) {
        this.resHandle = resHandle;
    }

    public Long getAudioLanguege() {
        return audioLanguege;
    }

    public void setAudioLanguege(Long audioLanguege) {
        this.audioLanguege = audioLanguege;
    }

    public String getMultiEpisode() {
        return multiEpisode;
    }

    public void setMultiEpisode(String multiEpisode) {
        this.multiEpisode = multiEpisode;
    }

    public String getResolution() {
        return resolution;
    }

    public void setResolution(String resolution) {
        this.resolution = resolution;
    }

    public int getResolutionType() {
        return resolutionType;
    }

    public void setResolutionType(int resolutionType) {
        this.resolutionType = resolutionType;
    }
}
