package com.valor.vod.meta.model.database.ddo.control;

import com.google.common.base.MoreObjects;
import com.valor.vod.api.model.constant.EVideoType;
import com.valor.vod.common.database.model.AbstractLMI;

import javax.persistence.*;

/**
 * Created by Frank.Huang on 2016/5/7.
 */
@Entity
@Table(name = "movie_meta_changed")
public class MovieMetaChanged extends AbstractLMI {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "id")
    protected long id;
    @Column(name = "vms_id")
    protected long vmsId;
    @Column(name = "language", length = 16)
    String language;
    @Column(name = "status")// 1:新增 2：修改
    int status = 0;
    @Column(name = "media_type")
    @Enumerated
    private EVideoType mediaType = EVideoType.UNKNOWN;

    public MovieMetaChanged() {
    }

    public MovieMetaChanged(long vmsId, String language, int status) {
        this.vmsId = vmsId;
        this.language = language;
        this.status = status;
    }

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getVmsId() {
        return vmsId;
    }

    public void setVmsId(long vmsId) {
        this.vmsId = vmsId;
    }

    public String getLanguage() {
        return language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public EVideoType getMediaType() {
        return mediaType;
    }

    public void setMediaType(EVideoType mediaType) {
        this.mediaType = mediaType;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
            .add("id", id)
            .add("vmsId", vmsId)
            .add("language", language)
            .add("status", status)
            .add("lastModifyTime", lastModifyTime)
            .toString();
    }
}
